<?php $__env->startSection('content'); ?>
    <style>
        .payment-card {
            border: 1px solid #e9ecef;
            border-radius: 12px;
            transition: all 0.25s ease;
        }

        .payment-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
        }

        .payment-logo {
            width: 56px;
            height: 56px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .payment-logo img {
            max-width: 100%;
            max-height: 100%;
            object-fit: contain;
        }

        .wallet-address {
            font-size: 0.85rem;
            color: #6c757d;
            word-break: break-all;
        }
    </style>

    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0"><?php echo e($title); ?></h4>
            </div>

            <div class="text-end">
                <?php if (isset($component)) { $__componentOriginalc60db44e52d942d3b0e4d76f7065f04b = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc60db44e52d942d3b0e4d76f7065f04b = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dashboard.breadcrumbs','data' => ['breadcrumbs' => $breadcrumbs]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dashboard.breadcrumbs'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['breadcrumbs' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($breadcrumbs)]); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc60db44e52d942d3b0e4d76f7065f04b)): ?>
<?php $attributes = $__attributesOriginalc60db44e52d942d3b0e4d76f7065f04b; ?>
<?php unset($__attributesOriginalc60db44e52d942d3b0e4d76f7065f04b); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc60db44e52d942d3b0e4d76f7065f04b)): ?>
<?php $component = $__componentOriginalc60db44e52d942d3b0e4d76f7065f04b; ?>
<?php unset($__componentOriginalc60db44e52d942d3b0e4d76f7065f04b); ?>
<?php endif; ?>
            </div>
        </div>

        <div class="row">
            <div class="col-12 mt-3">

                <!-- Section Header -->
                <div class="mb-4">
                    <h2 class="fw-semibold mb-2">Select Payment Method</h2>
                    <p class="text-muted mb-3">
                        Choose a preferred payment option below. All transactions are processed securely and
                        efficiently.
                    </p>
                    <hr>
                </div>

                <!-- Crypto Payments -->
                <div class="mb-4">
                    <h4 class="fw-semibold mb-1">Cryptocurrency Payments</h4>
                    <p class="text-muted">
                        Fund your account using supported blockchain networks.
                    </p>
                </div>

                <div class="row g-4">

                    <!-- Payment Card -->
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $wallets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $wallet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                        <div class="col-lg-4 col-md-6">
                            <a href="<?php echo e(route('user.deposit.payment', $wallet->uuid)); ?>" class="text-decoration-none">
                                <div class="card payment-card h-100">
                                    <div class="card-body d-flex align-items-center">
                                        <div class="payment-logo me-3">
                                            <img src="<?php echo e(asset($wallet->logo_path)); ?>" alt="<?php echo e($wallet->name); ?>"
                                                width="48">
                                        </div>
                                        <div>
                                            <h6 class="mb-0 fw-semibold"><?php echo e($wallet->name); ?></h6>
                                            <small class="text-muted"><?php echo e($wallet->network); ?></small>
                                            <p class="wallet-address mt-2 mb-0">
                                                <?php echo e($wallet->address); ?>

                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </a>
                        </div>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
                        <div class="col-12">
                            <div class="card border-0 bg-light">
                                <div class="card-body text-center py-5">
                                    <div class="mb-3">
                                        <i class="ti ti-wallet-off fs-1 text-muted"></i>
                                    </div>
                                    <h5 class="fw-semibold mb-2">No Payment Methods Available</h5>
                                    <p class="text-muted mb-0">
                                        Cryptocurrency payment options are currently unavailable.
                                        Please check back later or contact support for assistance.
                                    </p>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                </div>

            </div>

        </div>

    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.user.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\projects\broker-v6.0\resources\views/dashboard/user/deposit/method.blade.php ENDPATH**/ ?>