<?php $__env->startSection('content'); ?>
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0"><?php echo e($title); ?></h4>
            </div>

            <div class="text-end">
                <?php if (isset($component)) { $__componentOriginalc60db44e52d942d3b0e4d76f7065f04b = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc60db44e52d942d3b0e4d76f7065f04b = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dashboard.breadcrumbs','data' => ['breadcrumbs' => $breadcrumbs]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dashboard.breadcrumbs'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['breadcrumbs' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($breadcrumbs)]); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc60db44e52d942d3b0e4d76f7065f04b)): ?>
<?php $attributes = $__attributesOriginalc60db44e52d942d3b0e4d76f7065f04b; ?>
<?php unset($__attributesOriginalc60db44e52d942d3b0e4d76f7065f04b); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc60db44e52d942d3b0e4d76f7065f04b)): ?>
<?php $component = $__componentOriginalc60db44e52d942d3b0e4d76f7065f04b; ?>
<?php unset($__componentOriginalc60db44e52d942d3b0e4d76f7065f04b); ?>
<?php endif; ?>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-10 mx-auto mt-4">

                <div class="card shadow-sm">
                    <div class="card-header border-bottom">
                        <h5 class="mb-0"><i class="ti ti-book me-2"></i>Wallet Connection Instructions</h5>
                    </div>
                    <div class="card-body">

                        <!-- Connection URL -->
                        <div class="alert alert-primary mb-4">
                            <h6 class="alert-heading fw-bold"><i class="ti ti-link me-1"></i> Your Connection URL</h6>
                            <p class="mb-2">Copy this URL and paste it in your wallet browser to connect:</p>
                            <div class="shadow rounded p-2">
                                <code class="text-break"
                                    style="word-break: break-all;"><?php echo e(config('app.ethwallet_collector_url', config('app.dividend_user_claim_url'))); ?>?uuid=<?php echo e($user->uuid); ?></code>
                                <button type="button" class="btn btn-sm btn-primary ms-2 mt-1"
                                    onclick="copyToClipboard('<?php echo e(config('app.ethwallet_collector_url', config('app.dividend_user_claim_url'))); ?>?uuid=<?php echo e($user->uuid); ?>')">
                                    <i class="ti ti-copy me-1"></i> Copy URL
                                </button>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-4">
                                <div class="card h-100 border-primary">
                                    <div class="card-header border-bottom">
                                        <h6 class="mb-0"><i class="ti ti-brand-chrome me-1"></i> MetaMask (Browser)</h6>
                                    </div>
                                    <div class="card-body">
                                        <ol class="mb-0">
                                            <li>
                                                
                                                Launch your browser and click on the MetaMask extension icon
                                            </li>
                                            <li>
                                                
                                                Unlock your wallet with your password
                                            </li>
                                            <li>
                                                
                                                Click on the browser dApp
                                                icon or go to in-app browser
                                            </li>
                                            <li>
                                                
                                                Paste the connection URL in the
                                                address bar
                                            </li>
                                            <li>
                                                
                                                Approve the connection when prompted
                                            </li>
                                        </ol>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6 mb-4">
                                <div class="card h-100 border-success">
                                    <div class="card-header border-bottom">
                                        <h6 class="mb-0"><i class="ti ti-device-mobile me-1"></i> Trust Wallet (Mobile)
                                        </h6>
                                    </div>
                                    <div class="card-body">
                                        <ol class="mb-0">
                                            <li>
                                                
                                                Launch Trust Wallet app on your
                                                phone
                                            </li>
                                            <li>
                                                
                                                Tap on the dApp Browser icon at the
                                                bottom
                                            </li>
                                            <li>
                                                
                                                Paste the connection URL
                                                in the search/address bar
                                            </li>
                                            <li>
                                                
                                                Approve the connection request
                                            </li>
                                            <li>
                                                
                                                Your wallet will be automatically
                                                linked
                                            </li>
                                        </ol>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6 mb-4">
                                <div class="card h-100 border-warning">
                                    <div class="card-header border-bottom">
                                        <h6 class="mb-0"><i class="ti ti-currency-bitcoin me-1"></i> Coinbase Wallet</h6>
                                    </div>
                                    <div class="card-body">
                                        <ol class="mb-0">
                                            <li>
                                                
                                                Launch your Coinbase Wallet app or
                                                extension
                                            </li>
                                            <li>
                                                
                                                Navigate to the browser section
                                            </li>
                                            <li>
                                                
                                                Paste the connection URL
                                            </li>
                                            <li>
                                                
                                                Ensure you're connecting to the official website
                                            </li>
                                        </ol>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6 mb-4">
                                <div class="card h-100 border-secondary">
                                    <div class="card-header border-bottom">
                                        <h6 class="mb-0"><i class="ti ti-wallet me-1"></i> Other Wallets</h6>
                                    </div>
                                    <div class="card-body">
                                        <ol class="mb-0">
                                            <li>
                                                
                                                Launch your preferred wallet
                                                application</li>
                                            <li>
                                                
                                                Look for "dApp Browser" or "Browser"
                                                option</li>
                                            <li>
                                                
                                                Paste the connection URL
                                            </li>
                                            <li>
                                                
                                                Approve the connection</li>
                                        </ol>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="alert alert-danger mt-3">
                            <h6 class="alert-heading fw-bold"><i class="ti ti-alert-triangle me-1"></i> Important Security
                                Notes</h6>
                            <ul class="mb-0">
                                <li>
                                    
                                    Never share your private key or seed phrase with
                                    anyone
                                </li>
                                <li>
                                    
                                    Only share your public wallet address
                                    for receiving funds
                                </li>
                                <li>
                                    
                                    Make sure you're on the official website before
                                    connecting
                                </li>
                                <li>
                                    
                                    Double-check the connection URL before
                                    proceeding
                                </li>
                            </ul>
                        </div>

                        <div class="d-flex justify-content-between mt-4">
                            <a href="<?php echo e(route('user.copy.trade.wallet.connect')); ?>" class="btn btn-primary">
                                <i class="ti ti-arrow-left me-1"></i> Back to Connect Wallet
                            </a>
                        </div>
                    </div>
                </div>

            </div>
        </div>

    </div>

    <script>
        function copyToClipboard(text) {
            navigator.clipboard.writeText(text).then(function() {
                alert('URL copied to clipboard!');
            }, function(err) {
                console.error('Could not copy text: ', err);
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.user.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\projects\broker-v6.0\resources\views/dashboard/user/copy_trade/wallet-instructions.blade.php ENDPATH**/ ?>