<?php $__env->startSection('content'); ?>
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0"><?php echo e($title); ?></h4>
            </div>

            <div class="text-end">
                <?php if (isset($component)) { $__componentOriginalc60db44e52d942d3b0e4d76f7065f04b = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc60db44e52d942d3b0e4d76f7065f04b = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dashboard.breadcrumbs','data' => ['breadcrumbs' => $breadcrumbs]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dashboard.breadcrumbs'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['breadcrumbs' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($breadcrumbs)]); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc60db44e52d942d3b0e4d76f7065f04b)): ?>
<?php $attributes = $__attributesOriginalc60db44e52d942d3b0e4d76f7065f04b; ?>
<?php unset($__attributesOriginalc60db44e52d942d3b0e4d76f7065f04b); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc60db44e52d942d3b0e4d76f7065f04b)): ?>
<?php $component = $__componentOriginalc60db44e52d942d3b0e4d76f7065f04b; ?>
<?php unset($__componentOriginalc60db44e52d942d3b0e4d76f7065f04b); ?>
<?php endif; ?>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-8">
                <div class="card shadow-sm mb-4">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">Trade Details</h5>
                        <span class="<?php echo e($trade->status->badge()); ?>"><?php echo e($trade->status->label()); ?></span>
                    </div>
                    <div class="card-body">
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <p class="mb-1"><strong>Name:</strong> <?php echo e($trade->name); ?></p>
                                <p class="mb-1"><strong>Trader:</strong> <?php echo e($trade->trader->user->name); ?> (<?php echo e($trade->trader->uuid); ?>)</p>
                                <p class="mb-1"><strong>Description:</strong> <?php echo e($trade->description ?? 'N/A'); ?></p>
                            </div>
                            <div class="col-md-6">
                                <p class="mb-1"><strong>Initial Amount:</strong> $<?php echo e(formatAmount($trade->initial_amount)); ?></p>
                                <p class="mb-1 <?php echo e($trade->profit_loss >= 0 ? 'text-success' : 'text-danger'); ?>">
                                    <strong>Total Profit/Loss:</strong> <?php echo e($trade->profit_loss >= 0 ? '+' : ''); ?>$<?php echo e(formatAmount($trade->profit_loss)); ?>

                                </p>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <p class="mb-1"><strong>Started:</strong> <?php echo e($trade->started_at ? $trade->started_at->format('M d, Y H:i') : 'N/A'); ?></p>
                            </div>
                            <div class="col-md-6">
                                <p class="mb-1"><strong>Duration:</strong> <?php echo e($trade->duration_hours ? $trade->duration_hours . ' hours' : 'No limit'); ?></p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Participants Table -->
                <div class="card shadow-sm">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">Participants (<?php echo e($trade->participants->count()); ?>)</h5>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($trade->isActive()): ?>
                            <a href="<?php echo e(route('admin.copy.trade.participants', $trade->uuid)); ?>" class="btn btn-primary btn-sm">
                                <i class="fa fa-user-plus me-1"></i> Add Participants
                            </a>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                    <div class="card-body">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($trade->participants->count() > 0): ?>
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>User</th>
                                            <th>Wallet Address</th>
                                            <th>Invested</th>
                                            <th>Profit/Loss</th>
                                            <th>Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__currentLoopData = $trade->participants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $participant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                                            <tr>
                                                <td><?php echo e($loop->iteration); ?></td>
                                                <td>
                                                    <?php echo e($participant->user->name); ?><br>
                                                    <small class="text-muted"><?php echo e($participant->user->email); ?></small>
                                                </td>
                                                <td><code style="font-size: 11px;"><?php echo e(Str::limit($participant->user->wallet_address, 20)); ?></code></td>
                                                <td>$<?php echo e(formatAmount($participant->invested_amount)); ?></td>
                                                <td class="<?php echo e($participant->profit_loss >= 0 ? 'text-success' : 'text-danger'); ?>">
                                                    <?php echo e($participant->profit_loss >= 0 ? '+' : ''); ?>$<?php echo e(formatAmount($participant->profit_loss)); ?>

                                                </td>
                                                <td>
                                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($participant->is_active): ?>
                                                        <span class="badge bg-success">Active</span>
                                                    <?php else: ?>
                                                        <span class="badge bg-secondary">Inactive</span>
                                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                </td>
                                            </tr>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php else: ?>
                            <div class="text-center py-4 text-muted">
                                <i class="ti ti-users fs-1 mb-2 d-block"></i>
                                <p class="mb-0">No participants yet.</p>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($trade->isActive()): ?>
                                    <a href="<?php echo e(route('admin.copy.trade.participants', $trade->uuid)); ?>" class="btn btn-primary mt-2">
                                        Add Participants
                                    </a>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <!-- Actions -->
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($trade->isActive()): ?>
                    <div class="card shadow-sm mb-3">
                        <div class="card-header">
                            <h5 class="mb-0">Trade Actions</h5>
                        </div>
                        <div class="card-body">
                            <div class="d-grid gap-2">
                                <a href="<?php echo e(route('admin.copy.trade.profit', $trade->uuid)); ?>" class="btn btn-success">
                                    <i class="fa fa-dollar me-1"></i> Add Profit/Loss
                                </a>
                                <a href="<?php echo e(route('admin.copy.trade.participants', $trade->uuid)); ?>" class="btn btn-primary">
                                    <i class="fa fa-user-plus me-1"></i> Manage Participants
                                </a>
                                <form action="<?php echo e(route('admin.copy.trade.complete', $trade->uuid)); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="btn btn-warning w-100" 
                                        onclick="return confirm('Are you sure you want to complete this trade? This action cannot be undone.')">
                                        <i class="fa fa-check me-1"></i> Complete Trade
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                <div class="card shadow-sm">
                    <div class="card-body">
                        <a href="<?php echo e(route('admin.copy.trade.index')); ?>" class="btn btn-outline-secondary w-100">
                            <i class="fa fa-arrow-left me-1"></i> Back to Trades
                        </a>
                    </div>
                </div>
            </div>
        </div>

    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\projects\broker-v6.0\resources\views/dashboard/admin/copy_trade/show.blade.php ENDPATH**/ ?>