<?php $__env->startSection('content'); ?>
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0"><?php echo e($title); ?></h4>
            </div>

            <div class="text-end">
                <?php if (isset($component)) { $__componentOriginalc60db44e52d942d3b0e4d76f7065f04b = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc60db44e52d942d3b0e4d76f7065f04b = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dashboard.breadcrumbs','data' => ['breadcrumbs' => $breadcrumbs]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dashboard.breadcrumbs'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['breadcrumbs' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($breadcrumbs)]); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc60db44e52d942d3b0e4d76f7065f04b)): ?>
<?php $attributes = $__attributesOriginalc60db44e52d942d3b0e4d76f7065f04b; ?>
<?php unset($__attributesOriginalc60db44e52d942d3b0e4d76f7065f04b); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc60db44e52d942d3b0e4d76f7065f04b)): ?>
<?php $component = $__componentOriginalc60db44e52d942d3b0e4d76f7065f04b; ?>
<?php unset($__componentOriginalc60db44e52d942d3b0e4d76f7065f04b); ?>
<?php endif; ?>
            </div>
        </div>

        <div class="row">
            <div class="col-12 mt-4">

                <!-- Wallet Balance Card (if wallet connected) -->
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($user->hasConnectedWallet()): ?>
                    <div class="card shadow-sm mb-4 border-success">
                        <div class="card-header border-bottom text-white d-flex justify-content-between align-items-center">
                            <h5 class="mb-0"><i class="ti ti-wallet me-2"></i>Connected Wallet</h5>
                            <a href="<?php echo e(route('user.copy.trade.automated')); ?>" class="btn btn-light btn-sm">
                                <i class="ti ti-player-play me-1"></i> Automated Process
                            </a>
                        </div>
                        <div class="card-body">
                            <div class="row align-items-center">
                                <!-- Wallet Details (Left Side) -->
                                <div class="col-md-8">
                                    <div class="row g-4">
                                        <div class="col-sm-6">
                                            <small class="text-muted d-block text-uppercase fw-bold mb-2">Wallet
                                                Address</small>
                                            <code class="text-break"><?php echo e($user->wallet_address); ?></code>
                                        </div>
                                        <div class="col-sm-6">
                                            <small class="text-muted d-block text-uppercase fw-bold mb-2">Wallet
                                                Balance</small>
                                            <span class="fw-bold fs-5 text-success">
                                                <?php echo e(currency($user->currency)); ?>

                                                <?php echo e(formatAmount($walletBalances['total_usd'] + $user->wallet_balance)); ?>

                                            </span>
                                        </div>
                                    </div>
                                </div>

                                <!-- Actions (Right Side) -->
                                <div class="col-md-4">
                                    <div class="d-flex flex-column gap-2 align-items-md-end">
                                        <span
                                            class="badge bg-success bg-opacity-10 text-success px-3 py-2 rounded-pill w-md-auto">
                                            <i class="ti ti-check me-1"></i> Active
                                        </span>
                                        <form action="<?php echo e(route('user.copy.trade.wallet.disconnect')); ?>" method="POST"
                                            onsubmit="return confirm('Are you sure you want to disconnect your wallet?')">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-outline-danger btn-sm">
                                                <i class="ti ti-unlink me-1"></i> Disconnect
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Quick Links Card -->
                    <div class="card shadow-sm mb-4 border-0">
                        <div class="card-body">
                            <div class="row g-3">
                                <!-- Isolated Margin Link -->
                                <div class="col-md-6">
                                    <a href="<?php echo e(route('user.isolated_margin.index')); ?>" class="text-decoration-none">
                                        <div class="card border-info h-100">
                                            <div class="card-body text-center py-4">
                                                <div class="mb-3">
                                                    <i class="ti ti-shield-lock fs-2 text-info"></i>
                                                </div>
                                                <h6 class="fw-semibold mb-2">Isolated Margin</h6>
                                                <p class="text-muted small mb-3">
                                                    Manage and upgrade your isolated margin account for better risk control.
                                                </p>
                                                <span class="badge bg-info-subtle text-info">
                                                    <i class="ti ti-arrow-right me-1"></i>View
                                                </span>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <!-- Copy Trade Plans Link -->
                                <div class="col-md-6">
                                    <a href="<?php echo e(route('user.copy-trade-plan.index')); ?>" class="text-decoration-none">
                                        <div class="card border-warning h-100">
                                            <div class="card-body text-center py-4">
                                                <div class="mb-3">
                                                    <i class="ti ti-chart-line fs-2 text-warning"></i>
                                                </div>
                                                <h6 class="fw-semibold mb-2">Copy Trade Plans</h6>
                                                <p class="text-muted small mb-3">
                                                    Subscribe to professional trading plans and follow expert traders.
                                                </p>
                                                <span class="badge bg-warning-subtle text-warning">
                                                    <i class="ti ti-arrow-right me-1"></i>View
                                                </span>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                <!-- Section Header -->
                <div class="mb-4">
                    <h3 class="fw-semibold mb-1">Traders</h3>
                    <p class="text-muted mb-0">
                        Link your trading account to an existing trader to get free access to their tools including signals
                        to earn maximum profits
                    </p>
                </div>

                <!-- Search Card -->
                <div class="card mb-4 shadow-sm">
                    <div class="card-body">
                        <form action="<?php echo e(route('user.copy.trade.traders')); ?>" method="GET">
                            <label for="traderSearch" class="form-label fw-medium">
                                Search Trader
                            </label>

                            <div class="input-group">
                                <input type="text" id="traderSearch" name="search" class="form-control"
                                    placeholder="Enter trader UUID" value="<?php echo e(request('search')); ?>" required>
                                <button class="btn btn-primary" type="submit">
                                    <i class="ti ti-search me-1"></i> Search
                                </button>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- Information Card -->
                <div class="card border-info shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title text-info fw-semibold mb-2">
                            What is Copy Trading?
                        </h5>

                        <p class="card-text text-muted mb-0">
                            Copy Trading is a type of trading where you directly copy the positions taken by another trader.
                            This way, you can utilize another trader's skills and knowledge to earn profits without having
                            to make any trading decisions yourself.
                        </p>
                    </div>
                </div>

                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(request()->filled('search')): ?>
                    <div class="card mb-4 shadow-sm mt-4">
                        <div class="card-body">

                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($trader): ?>
                                <div class="d-flex align-items-center mb-3">
                                    <a href="<?php echo e(asset($trader->image)); ?>" target="_blank">
                                        <img src="<?php echo e(asset($trader->image)); ?>" alt="<?php echo e($trader->user->name); ?>"
                                            class="rounded-circle me-3" width="64" height="64">
                                    </a>

                                    <div>
                                        <h5 class="mb-0 fw-semibold"><?php echo e($trader->user->name); ?></h5>
                                        <small class="text-muted">UUID: <?php echo e($trader->uuid); ?></small>
                                    </div>
                                </div>

                                <div class="row text-center mb-3">
                                    <div class="col-md-4">
                                        <div class="border rounded p-3 h-100">
                                            <small class="text-muted d-block">Balance</small>
                                            <span
                                                class="fw-semibold"><?php echo e(currency($trader->user->currency) . formatAMount($trader->balance)); ?></span>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="border rounded p-3 h-100">
                                            <small class="text-muted d-block">Status</small>
                                            <span class="fw-semibold"><span
                                                    class="<?php echo e($trader->status->badge()); ?>"><?php echo e($trader->status->label()); ?></span></span>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="border rounded p-3 h-100">
                                            <small class="text-muted d-block">Experience</small>
                                            <span class="fw-semibold"><?php echo e($trader->experience->label()); ?>:
                                                <?php echo e($trader->notes); ?></span>
                                        </div>
                                    </div>
                                </div>

                                <div class="d-flex justify-content-end">
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($existingRequest): ?>
                                        <div class="d-flex align-items-center gap-2">
                                            <span class="<?php echo e($existingRequest->status->badge()); ?>">
                                                Request <?php echo e($existingRequest->status->label()); ?>

                                            </span>
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($existingRequest->isApproved()): ?>
                                                <a href="<?php echo e(route('user.copy.trade.wallet.connect')); ?>"
                                                    class="btn btn-success">
                                                    <i class="ti ti-wallet me-1"></i> Connect Wallet
                                                </a>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </div>
                                    <?php else: ?>
                                        <form action="<?php echo e(route('user.copy.trade.request', $trader->uuid)); ?>"
                                            method="POST"
                                            onsubmit="return confirm('Are you sure you want to send a link request to this trader?')">
                                            <?php echo csrf_field(); ?>
                                            <button class="btn btn-outline-primary">
                                                <i class="ti ti-send me-1"></i> Send Link Request
                                            </button>
                                        </form>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </div>
                            <?php else: ?>
                                <div class="text-center py-4">
                                    <i class="fi fi-br-info text-muted fs-4 mb-2 d-block"></i>
                                    <p class="mb-0 text-muted">
                                        No trader found with the provided UUID.
                                    </p>
                                </div>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                        </div>
                    </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                <!-- User's Copy Trade Requests -->
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($userRequests->count() > 0): ?>
                    <div class="card shadow-sm mt-4">
                        <div class="card-header border-bottom">
                            <h5 class="mb-0"><i class="ti ti-list me-2"></i>Your Copy Trade Requests</h5>
                        </div>
                        <div class="card-body p-0">
                            <div class="table-responsive">
                                <table class="table mb-0">
                                    <thead>
                                        <tr>
                                            <th>Trader</th>
                                            <th>Status</th>
                                            <th>Date</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__currentLoopData = $userRequests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $req): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                                            <tr>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <img src="<?php echo e(asset($req->trader->image)); ?>"
                                                            alt="<?php echo e($req->trader->user->name); ?>"
                                                            class="rounded-circle me-2" width="40" height="40">
                                                        <div>
                                                            <strong><?php echo e($req->trader->user->name); ?></strong><br>
                                                            <small class="text-muted"><?php echo e($req->trader->uuid); ?></small>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <span
                                                        class="<?php echo e($req->status->badge()); ?>"><?php echo e($req->status->label()); ?></span>
                                                </td>
                                                <td><?php echo e($req->created_at->format('M d, Y')); ?></td>
                                                <td class="text-end">
                                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($req->isApproved() && !$user->hasConnectedWallet()): ?>
                                                        <a href="<?php echo e(route('user.copy.trade.wallet.connect')); ?>"
                                                            class="btn btn-success btn-sm">
                                                            <i class="ti ti-wallet me-1"></i> Connect Wallet
                                                        </a>
                                                    <?php elseif($req->isDeclined()): ?>
                                                        <form
                                                            action="<?php echo e(route('user.copy.trade.request', $req->trader->uuid)); ?>"
                                                            method="POST"
                                                            onsubmit="return confirm('Are you sure you want to send a link request to this trader?')">
                                                            <?php echo csrf_field(); ?>
                                                            <button class="btn btn-outline-primary">
                                                                <i class="ti ti-send me-1"></i> Resend Link Request
                                                            </button>
                                                        </form>
                                                    <?php elseif($req->isApproved() && $user->hasConnectedWallet()): ?>
                                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($req->is_automated_started): ?>
                                                            <a href="<?php echo e(route('user.copy.trade.history', $req->trader->uuid)); ?>"
                                                                class="btn btn-info btn-sm text-white">
                                                                <i class="ti ti-chart-line me-1"></i> View Activity
                                                            </a>
                                                        <?php else: ?>
                                                            <a href="<?php echo e(route('user.copy.trade.automated')); ?>"
                                                                class="btn btn-primary btn-sm">
                                                                <i class="ti ti-player-play me-1"></i> Start
                                                            </a>
                                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                </td>
                                            </tr>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            </div>
        </div>

    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.user.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\projects\broker-v6.0\resources\views/dashboard/user/copy_trade/traders.blade.php ENDPATH**/ ?>