<!DOCTYPE html>
<html lang="en">

    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width,initial-scale=1.0">
        <style>
            body {
                font-family: Arial, sans-serif;
                background-color: #f4f6f9;
                margin: 0;
                padding: 0;
                color: #333;
            }

            .container {
                max-width: 650px;
                margin: 40px auto;
                background: #fff;
                border-radius: 8px;
                overflow: hidden;
                box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
            }

            .header {
                background: linear-gradient(135deg, #1c223c, #3d56f0);
                color: #fff;
                text-align: center;
                padding: 24px;
            }

            .header h1 {
                margin: 0;
                font-size: 22px;
            }

            .header p {
                margin: 4px 0 0;
                font-size: 14px;
            }

            .content {
                padding: 24px;
            }

            .content h2 {
                color: #3d56f0;
                font-size: 18px;
                margin-top: 10px;
            }

            .content p {
                line-height: 1.6;
                font-size: 14px;
            }

            .box {
                background: #f8f9fd;
                border-radius: 6px;
                padding: 16px;
                margin: 20px 0;
            }

            .box h3 {
                margin-top: 0;
                font-size: 14px;
                font-weight: bold;
            }

            .details {
                border: 1px solid #e0e0e0;
                border-radius: 6px;
                margin-top: 10px;
                overflow: hidden;
            }

            .details-header {
                background: #3d56f0;
                color: #fff;
                padding: 10px;
                font-weight: bold;
                font-size: 14px;
            }

            .details table {
                width: 100%;
                border-collapse: collapse;
            }

            .details td {
                padding: 10px;
                font-size: 13px;
                border-top: 1px solid #eee;
            }

            .details td:first-child {
                font-weight: bold;
                width: 35%;
                background: #fafafa;
            }

            .cta {
                text-align: center;
                margin: 20px 0;
            }

            .cta a {
                background: #3d56f0;
                color: #fff;
                text-decoration: none;
                padding: 12px 24px;
                border-radius: 6px;
                font-size: 14px;
                display: inline-block;
            }

            .important {
                background: #fff8e5;
                border-left: 4px solid #f7c948;
                padding: 12px;
                font-size: 14px;
                margin: 20px 0;
            }

            .footer {
                font-size: 12px;
                color: #777;
                border-top: 1px solid #e0e0e0;
                padding: 16px 24px;
                text-align: center;
                background: #fafafa;
            }

            .footer a {
                color: #3d56f0;
                text-decoration: none;
            }
        </style>
    </head>

    <body>
        <div class="container">
            <!-- Header -->
            <div class="header">
                <h1><?php echo e(config('app.name')); ?></h1>
                <p>Welcome to <?php echo e(config('app.name')); ?></p>
                <small>Your Trading Journey Starts Here</small>
            </div>

            <!-- Body -->
            <div class="content">
                <p>Dear <?php echo e($user->name); ?>,</p>
                <h2>Your Trading Account Is Now Active</h2>
                <p>
                    Welcome to <?php echo e(config('app.name')); ?> — a powerful trading platform built to help you take control of
                    your financial future.
                </p>
                <p>
                    You now have access to global markets, professional-grade tools, and real-time analytics to enhance
                    your trading experience.
                </p>
                <p>
                    Whether you’re trading forex, crypto, commodities, or indices — your success starts with smart
                    execution and the right platform.
                </p>

                <!-- What's Next -->
                <div class="box">
                    <h3>Getting Started</h3>
                    <ul>
                        <li>Log in to your trading dashboard</li>
                        <li>Verify your trading account (KYC)</li>
                        <li>Fund your wallet and start trading live markets</li>
                    </ul>
                </div>

                <!-- Account Details -->
                <div class="details">
                    <div class="details-header">Your Account Details</div>
                    <table>
                        <tr>
                            <td>Name</td>
                            <td><?php echo e($user->name); ?></td>
                        </tr>
                        <tr>
                            <td>Account Type</td>
                            <td><?php echo e($user->account_type->label()); ?></td>
                        </tr>
                        <tr>
                            <td>Base Currency</td>
                            <td><?php echo e(currency($user->currency, 'code')); ?></td>
                        </tr>
                        <tr>
                            <td>Created On</td>
                            <td><?php echo e(formatDateTime($user->created_at)); ?></td>
                        </tr>
                    </table>
                </div>

                <!-- Trading Portal Access -->
                <div class="details">
                    <div class="details-header">Trading Portal Access</div>
                    <table>
                        <tr>
                            <td>Email</td>
                            <td><?php echo e($user->email); ?></td>
                        </tr>
                        <tr>
                            <td>Password</td>
                            <td>Your chosen password</td>
                        </tr>
                    </table>
                </div>

                <!-- Call to Action -->
                <div class="cta">
                    <a href="<?php echo e(route('login')); ?>">Access Trading Dashboard</a>
                </div>

                <!-- Important -->
                <div class="important">
                    <strong>Need Assistance?</strong>
                    For help setting up your account, funding, or trading support, contact our support team at
                    <a href="mailto:<?php echo e(config('app.email')); ?>"><?php echo e(config('app.email')); ?></a>.
                </div>

                <p><strong>Our Promise to Traders</strong><br>
                    <?php echo e(config('app.name')); ?> is dedicated to empowering traders with advanced technology, transparent
                    pricing,
                    and world-class support. Your trading success is our mission — we’re here every step of the way.
                </p>

                <p>Thank you for choosing <?php echo e(config('app.name')); ?><br>
                    <strong>The <?php echo e(config('app.name')); ?> Team</strong>
                </p>
            </div>

            <!-- Footer -->
            <div class="footer">
                © <?php echo e(date('Y')); ?> <?php echo e(config('app.name')); ?>. All rights reserved.<br>
                If you have any questions, please contact
                <a href="mailto:<?php echo e(config('app.email')); ?>"><?php echo e(config('app.email')); ?></a>.
            </div>
        </div>
    </body>

</html>
<?php /**PATH C:\xampp\htdocs\projects\broker-v6.0\resources\views/mail/welcome.blade.php ENDPATH**/ ?>