<!DOCTYPE html>
<html lang="en">

    <head>
        <meta charset="UTF-8">
        <title>Deposit Confirmed</title>
        <meta name="viewport" content="width=device-width, initial-scale=1.0">

        <style>
            body {
                margin: 0;
                padding: 0;
                background-color: #f4f6f8;
                font-family: Arial, Helvetica, sans-serif;
            }

            .wrapper {
                width: 100%;
                padding: 20px 0;
                display: flex;
                justify-content: center;
            }

            .container {
                width: 600px;
                background: #ffffff;
                border-radius: 8px;
                overflow: hidden;
            }

            .header {
                background: #0d6efd;
                padding: 20px;
                text-align: center;
                color: #ffffff;
            }

            .header h1 {
                margin: 0;
                font-size: 22px;
            }

            .body {
                padding: 30px;
                color: #333333;
            }

            .body p {
                font-size: 15px;
                margin: 0 0 15px;
            }

            .success {
                color: #198754;
            }

            .details-box {
                background: #f8f9fa;
                border-radius: 6px;
                padding: 15px;
                margin-bottom: 25px;
            }

            .details-box p {
                font-size: 14px;
                margin: 0 0 8px;
            }

            .cta {
                text-align: center;
                margin: 25px 0 30px;
            }

            .cta a {
                display: inline-block;
                padding: 12px 24px;
                background: #0d6efd;
                color: #ffffff;
                text-decoration: none;
                font-size: 14px;
                border-radius: 6px;
            }

            .support {
                text-align: center;
                font-size: 14px;
                color: #555555;
            }

            .support a {
                color: #0d6efd;
                text-decoration: none;
            }

            .footer {
                background: #f1f3f5;
                padding: 15px;
                text-align: center;
                font-size: 12px;
                color: #6c757d;
            }

            @media (max-width: 620px) {
                .container {
                    width: 90%;
                }
            }
        </style>
    </head>

    <body>

        <div class="wrapper">
            <div class="container">

                <div class="header">
                    <h1>Deposit Confirmed</h1>
                </div>

                <div class="body">

                    <p>Hello <strong><?php echo e($user->name); ?></strong>,</p>

                    <p>
                        We’re pleased to inform you that your deposit has been
                        <strong class="success">successfully confirmed</strong>
                        and credited to your account.
                    </p>

                    <div class="details-box">
                        <p>
                            <strong>Amount:</strong>
                            <?php echo e(currency($user->currency) . formatAmount($transaction->amount)); ?>

                        </p>
                        <p>
                            <strong>Method:</strong> <?php echo e($transaction->method->label()); ?>

                        </p>
                        <p>
                            <strong>Transaction ID:</strong> <?php echo e($transaction->uuid); ?>

                        </p>
                        <p>
                            <strong>Date:</strong>
                            <?php echo e(formatDateTime($transaction->transaction_at)); ?>

                        </p>
                    </div>

                    <p>
                        Your balance has been updated and is now available for use.
                    </p>

                    <div class="cta">
                        <a href="<?php echo e(route('user.dashboard')); ?>">
                            Go to Dashboard
                        </a>
                    </div>

                    <div class="support">
                        <p>
                            If you have any questions, please do not hesitate to contact our support team.
                        </p>
                        <p>
                            Simply reply to this email or contact us at
                            <a href="mailto:<?php echo e(config('app.email')); ?>">
                                <?php echo e(config('app.email')); ?>

                            </a>.
                        </p>
                        <p>
                            You may also reach us on WhatsApp at
                            <a href="https://wa.me/<?php echo e(config('app.whatsapp_phone')); ?>">
                                <?php echo e(config('app.phone')); ?>

                            </a>.
                        </p>
                    </div>

                </div>

                <div class="footer">
                    © <?php echo e(date('Y')); ?> <?php echo e(config('app.name')); ?>. All rights reserved.
                </div>

            </div>
        </div>

    </body>

</html>
<?php /**PATH C:\xampp\htdocs\projects\broker-v6.0\resources\views/mail/deposit-confirmed.blade.php ENDPATH**/ ?>