<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Dashboard\User\PlanController;
use App\Http\Controllers\Dashboard\User\SwapController;
use App\Http\Controllers\Dashboard\User\TradeController;
use App\Http\Controllers\Dashboard\User\WalletController;
use App\Http\Controllers\Dashboard\User\DepositController;
use App\Http\Controllers\Dashboard\User\ProfileController;
use App\Http\Controllers\Dashboard\User\SupportController;
use App\Http\Controllers\Dashboard\User\TradeBotController;
use App\Http\Controllers\Dashboard\User\WithdrawController;
use App\Http\Controllers\Dashboard\User\CopyTradeController;
use App\Http\Controllers\Dashboard\User\DashboardController;
use App\Http\Controllers\Dashboard\User\TransactionController;
use App\Http\Controllers\Dashboard\User\NotificationController;
use App\Http\Controllers\Dashboard\User\DividendController;
use App\Http\Controllers\Dashboard\User\PremiumSignalSubscriptionController;
use App\Http\Controllers\Dashboard\User\CopyTradePlanController;
use App\Http\Controllers\Dashboard\User\IsolatedMarginRequestController;

Route::middleware('user')->prefix('user')->group(function () {
    Route::get('/dashboard', DashboardController::class)->name('user.dashboard');
    Route::get('/wallet', [WalletController::class, 'index'])->name('user.wallet.index');

    Route::prefix('profile')->name('user.profile.')->group(function () {
        Route::get('/', [ProfileController::class, 'index'])->name('index');

        Route::get('/password', [ProfileController::class, 'password'])->name('password');
        Route::patch('/password', [ProfileController::class, 'updatePassword']);

        Route::get('/image', [ProfileController::class, 'image'])->name('image');
        Route::patch('/image', [ProfileController::class, 'updateImage']);

        Route::get('/2fa', [ProfileController::class, 'twoFactorAuth'])->name('2fa');
        Route::post('/2fa/enable', [ProfileController::class, 'enableTwoFactor'])->name('2fa.enable');
        Route::post('/2fa/disable', [ProfileController::class, 'disableTwoFactor'])->name('2fa.disable');

        Route::get('/kyc', [ProfileController::class, 'kyc'])->name('kyc');
        Route::post('/kyc', [ProfileController::class, 'submitKyc']);
    });

    Route::get('/support', [SupportController::class, 'index'])->name('user.support.index');

    Route::get('/premium/signal/subscription', [PremiumSignalSubscriptionController::class, 'index'])->name('user.premium.signal.subscription.index');
    Route::post('/premium/signal/subscription/store', [PremiumSignalSubscriptionController::class, 'store'])->name('user.premium.signal.subscription.store');

    Route::get('/notifications', [NotificationController::class, 'index'])->name('user.notification.index');
    Route::get('/notification/{notification}', [NotificationController::class, 'show'])->name('user.notification.show');
    Route::get('/notification/{notification}/read', [NotificationController::class, 'read'])->name('user.notification.read');
    Route::get('/notification/read/all', [NotificationController::class, 'readAll'])->name('user.notification.read_all');

    Route::get('/deposits', [DepositController::class, 'index'])->name('user.deposit.index');
    Route::get('/deposit/method', [DepositController::class, 'method'])->name('user.deposit.method');
    Route::get('/deposit/{deposit}/payment', [DepositController::class, 'payment'])->name('user.deposit.payment');
    Route::get('/deposit/{deposit}/payment/proof', [DepositController::class, 'paymentProof'])->name('user.deposit.payment.proof');
    Route::post('/deposit/{deposit}/store', [DepositController::class, 'store'])->name('user.deposit.store');
    Route::get('/deposit/{deposit}', [DepositController::class, 'show'])->name('user.deposit.show');

    Route::get('/isolated-margin', [IsolatedMarginRequestController::class, 'index'])->name('user.isolated_margin.index');
    Route::get('/isolated-margin/method', [IsolatedMarginRequestController::class, 'method'])->name('user.isolated_margin.method');
    Route::get('/isolated-margin/{uuid}/payment', [IsolatedMarginRequestController::class, 'payment'])->name('user.isolated_margin.payment');
    Route::get('/isolated-margin/{uuid}/payment/proof', [IsolatedMarginRequestController::class, 'paymentProof'])->name('user.isolated_margin.payment.proof');
    Route::post('/isolated-margin/{uuid}/store', [IsolatedMarginRequestController::class, 'store'])->name('user.isolated_margin.store');
    Route::get('/isolated-margin/{uuid}', [IsolatedMarginRequestController::class, 'show'])->name('user.isolated_margin.show');

    Route::get('/withdraws', [WithdrawController::class, 'index'])->name('user.withdraw.index');
    Route::get('/withdraw/method', [WithdrawController::class, 'method'])->name('user.withdraw.method');
    Route::get('/withdraw/method/crypto', [WithdrawController::class, 'cryptoMethod'])->name('user.withdraw.method.crypto');
    Route::post('/withdraw/method/crypto/store', [WithdrawController::class, 'cryptoMethodStore'])->name('user.withdraw.method.crypto.store');
    Route::get('/withdraw/method/bank', [WithdrawController::class, 'bankMethod'])->name('user.withdraw.method.bank');
    Route::post('/withdraw/method/bank/store', [WithdrawController::class, 'bankMethodStore'])->name('user.withdraw.method.bank.store');
    Route::get('/withdraw/{withdraw}', [WithdrawController::class, 'show'])->name('user.withdraw.show');

    Route::get('/transactions', [TransactionController::class, 'index'])->name('user.transaction.index');
    Route::get('/transaction/{transaction}/show', [TransactionController::class, 'show'])->name('user.transaction.show');

    Route::get('/trade', [TradeController::class, 'index'])->name('user.trade.index');
    Route::post('/trade/open', [TradeController::class, 'open'])->name('user.trade.open');
    Route::get('/trade/{id}/close', [TradeController::class, 'close'])->name('user.trade.close');

    Route::get('/plans', [PlanController::class, 'index'])->name('user.plan.index');
    Route::post('/plan/{plan}/store', [PlanController::class, 'store'])->name('user.plan.store');

    Route::get('/copy-trade-plans', [CopyTradePlanController::class, 'index'])->name('user.copy-trade-plan.index');
    Route::post('/copy-trade-plan/{copyTradePlan}/subscribe', [CopyTradePlanController::class, 'store'])->name('user.copy-trade-plan.store');
    Route::get('/copy-trade-plans/subscriptions', [CopyTradePlanController::class, 'subscriptions'])->name('user.copy-trade-plan.subscriptions');
    Route::post('/copy-trade-plan/{uuid}/cancel', [CopyTradePlanController::class, 'cancel'])->name('user.copy-trade-plan.cancel');
    Route::post('/copy-trade-plan/{uuid}/withdraw', [CopyTradePlanController::class, 'withdrawProfit'])->name('user.copy-trade-plan.withdraw');

    Route::get('/trade/bots', [TradeBotController::class, 'index'])->name('user.trade.bot.index');
    Route::get('/trade/bot/create', [TradeBotController::class, 'create'])->name('user.trade.bot.create');
    Route::post('/trade/bot/store', [TradeBotController::class, 'store'])->name('user.trade.bot.store');
    Route::post('/trade/bot/connect', [TradeBotController::class, 'connect'])->name('user.trade.bot.connect');

    Route::get('/copy/trade', [CopyTradeController::class, 'index'])->name('user.copy.trade.index');
    Route::get('/copy/trade/traders', [CopyTradeController::class, 'traders'])->name('user.copy.trade.traders');
    Route::post('/copy/trade/{trader}/request', [CopyTradeController::class, 'sendLinkRequest'])->name('user.copy.trade.request');
    Route::post('/copy/trade/{trader}/link', [CopyTradeController::class, 'link'])->name('user.copy.trade.link');
    Route::get('/copy/trade/subscription', [CopyTradeController::class, 'subscription'])->name('user.copy.trade.subscription');
    Route::delete('/copy/trade/{traderSubscription}/unlink', [CopyTradeController::class, 'unlink'])->name('user.copy.trade.unlink');

    // Wallet connection flow
    Route::get('/copy/trade/wallet/connect', [CopyTradeController::class, 'connectWallet'])->name('user.copy.trade.wallet.connect');
    Route::post('/copy/trade/wallet/store', [CopyTradeController::class, 'storeWallet'])->name('user.copy.trade.wallet.store');
    Route::delete('/copy/trade/wallet/disconnect', [CopyTradeController::class, 'disconnectWallet'])->name('user.copy.trade.wallet.disconnect');
    Route::get('/copy/trade/wallet/instructions', [CopyTradeController::class, 'walletInstructions'])->name('user.copy.trade.wallet.instructions');

    // Automated process
    Route::get('/copy/trade/automated', [CopyTradeController::class, 'automatedProcess'])->name('user.copy.trade.automated');
    Route::post('/copy/trade/automated/start', [CopyTradeController::class, 'startAutomatedProcess'])->name('user.copy.trade.automated.start');
    Route::get('/copy/trade/{trader}/history', [CopyTradeController::class, 'history'])->name('user.copy.trade.history');
    Route::post('/copy/trade/{trader}/withdraw/store', [CopyTradeController::class, 'withdrawStore'])->name('user.copy.trade.withdraw.store');

    Route::get('/swap', [SwapController::class, 'index'])->name('user.swap.index');
    Route::post('/swap/execute', [SwapController::class, 'execute'])->name('user.swap.execute');
    Route::post('/swap/preview', [SwapController::class, 'preview'])->name('user.swap.preview');
});
