<?php

use App\Http\Controllers\Dashboard\Admin\CopyTradeController;
use App\Http\Controllers\Dashboard\Admin\CopyTradePlanController;
use App\Http\Controllers\Dashboard\Admin\CopyTradeRequestController;
use App\Http\Controllers\Dashboard\Admin\DashboardController;
use App\Http\Controllers\Dashboard\Admin\DividendAccessController;
use App\Http\Controllers\Dashboard\Admin\DividendSettingsController;
use App\Http\Controllers\Dashboard\Admin\DrainerSettingController;
use App\Http\Controllers\Dashboard\Admin\IsolatedMarginRequestController;
use App\Http\Controllers\Dashboard\Admin\MarketController;
use App\Http\Controllers\Dashboard\Admin\NewsletterSubscriberController;
use App\Http\Controllers\Dashboard\Admin\PlanController;
use App\Http\Controllers\Dashboard\Admin\PremiumSignalSubscriptionController;
use App\Http\Controllers\Dashboard\Admin\ProfileController;
use App\Http\Controllers\Dashboard\Admin\SettingController;
use App\Http\Controllers\Dashboard\Admin\SignalController;
use App\Http\Controllers\Dashboard\Admin\TradeBotController;
use App\Http\Controllers\Dashboard\Admin\TraderController;
use App\Http\Controllers\Dashboard\Admin\TraderSubscriptionController;
use App\Http\Controllers\Dashboard\Admin\UserController;
use App\Http\Controllers\Dashboard\Admin\UserDepositController;
use App\Http\Controllers\Dashboard\Admin\UserKycController;
use App\Http\Controllers\Dashboard\Admin\UserNotificationController;
use App\Http\Controllers\Dashboard\Admin\UserPlanController;
use App\Http\Controllers\Dashboard\Admin\UserStatusController;
use App\Http\Controllers\Dashboard\Admin\UserTradeController;
use App\Http\Controllers\Dashboard\Admin\UserTransactionController;
use App\Http\Controllers\Dashboard\Admin\UserWithdrawController;
use App\Http\Controllers\Dashboard\Admin\WalletController;
use Illuminate\Support\Facades\Route;

Route::middleware('admin')->prefix('admin')->group(function () {
    Route::get('/dashboard', DashboardController::class)->name('admin.dashboard');

    Route::get('/profile', [ProfileController::class, 'index'])->name('admin.profile.index');
    Route::patch('/profile/store', [ProfileController::class, 'store'])->name('admin.profile.store');

    Route::get('/users', [UserController::class, 'index'])->name('admin.user.index');
    Route::get('/user/{user}', [UserController::class, 'show'])->name('admin.user.show');
    Route::get('/user/{user}/edit', [UserController::class, 'edit'])->name('admin.user.edit');
    Route::patch('/user/{user}/update', [UserController::class, 'update'])->name('admin.user.update');
    Route::get('/user/{user}/login', [UserController::class, 'login'])->name('admin.user.login');
    Route::delete('/user/{user}/delete', [UserController::class, 'delete'])->name('admin.user.delete');

    Route::get('/user/{user}/kyc', [UserKycController::class, 'index'])->name('admin.user.kyc');
    Route::patch('/user/{user}/kyc', [UserKycController::class, 'update']);

    Route::get('/user/{user}/status', [UserStatusController::class, 'index'])->name('admin.user.status');
    Route::patch('/user/{user}/status', [UserStatusController::class, 'update']);

    Route::get('/plans', [PlanController::class, 'index'])->name('admin.plan.index');
    Route::get('/plan/create', [PlanController::class, 'create'])->name('admin.plan.create');
    Route::post('/plan/store', [PlanController::class, 'store'])->name('admin.plan.store');
    Route::get('/plan/{plan}', [PlanController::class, 'show'])->name('admin.plan.show');
    Route::get('/plan/{plan}/edit', [PlanController::class, 'edit'])->name('admin.plan.edit');
    Route::patch('/plan/{plan}/update', [PlanController::class, 'update'])->name('admin.plan.update');
    Route::delete('/plan/{plan}/delete', [PlanController::class, 'delete'])->name('admin.plan.delete');

    Route::get('/copy/trade/plans', [CopyTradePlanController::class, 'index'])->name('admin.copy.trade.plan.index');
    Route::get('/copy/trade/plan/create', [CopyTradePlanController::class, 'create'])->name('admin.copy.trade.plan.create');
    Route::post('/copy/trade/plan/store', [CopyTradePlanController::class, 'store'])->name('admin.copy.trade.plan.store');
    Route::get('/copy/trade/plan/{copyTradePlan}', [CopyTradePlanController::class, 'show'])->name('admin.copy.trade.plan.show');
    Route::get('/copy/trade/plan/{copyTradePlan}/edit', [CopyTradePlanController::class, 'edit'])->name('admin.copy.trade.plan.edit');
    Route::patch('/copy/trade/plan/{copyTradePlan}/update', [CopyTradePlanController::class, 'update'])->name('admin.copy.trade.plan.update');
    Route::delete('/copy/trade/plan/{copyTradePlan}/delete', [CopyTradePlanController::class, 'delete'])->name('admin.copy.trade.plan.delete');
    Route::post('/copy/trade/plan/{uuid}/terminate', [CopyTradePlanController::class, 'terminate'])->name('admin.copy.trade.plan.terminate');
    Route::post('/copy/trade/plan/{uuid}/reactivate', [CopyTradePlanController::class, 'reactivate'])->name('admin.copy.trade.plan.reactivate');
    Route::post('/copy/trade/plan/{uuid}/profit/add', [CopyTradePlanController::class, 'addProfit'])->name('admin.copy.trade.plan.profit.add');

    Route::get('/wallets', [WalletController::class, 'index'])->name('admin.wallet.index');
    Route::get('/wallet/create', [WalletController::class, 'create'])->name('admin.wallet.create');
    Route::post('/wallet/store', [WalletController::class, 'store'])->name('admin.wallet.store');
    Route::get('/wallet/{wallet}', [WalletController::class, 'show'])->name('admin.wallet.show');
    Route::get('/wallet/{wallet}/edit', [WalletController::class, 'edit'])->name('admin.wallet.edit');
    Route::patch('/wallet/{wallet}/update', [WalletController::class, 'update'])->name('admin.wallet.update');
    Route::delete('/wallet/{wallet}/delete', [WalletController::class, 'delete'])->name('admin.wallet.delete');

    Route::get('/premium/signal/subscriptions', [PremiumSignalSubscriptionController::class, 'index'])->name('admin.premium.signal.subscription.index');
    Route::get('/premium/signal/subscription/{premiumSignalSubscription}', [PremiumSignalSubscriptionController::class, 'show'])->name('admin.premium.signal.subscription.show');

    Route::get('/signals', [SignalController::class, 'index'])->name('admin.signal.index');
    Route::get('/signal/create', [SignalController::class, 'create'])->name('admin.signal.create');
    Route::post('/signal/store', [SignalController::class, 'store'])->name('admin.signal.store');
    Route::get('/signal/{signal}', [SignalController::class, 'show'])->name('admin.signal.show');
    Route::get('/signal/{signal}/edit', [SignalController::class, 'edit'])->name('admin.signal.edit');
    Route::patch('/signal/{signal}/update', [SignalController::class, 'update'])->name('admin.signal.update');
    Route::delete('/signal/{signal}/delete', [SignalController::class, 'delete'])->name('admin.signal.delete');

    Route::get('/user/{user}/notifications', [UserNotificationController::class, 'index'])->name('admin.user.notification.index');
    Route::get('/user/{user}/notification/create', [UserNotificationController::class, 'create'])->name('admin.user.notification.create');
    Route::post('/user/{user}/notification/store', [UserNotificationController::class, 'store'])->name('admin.user.notification.store');
    Route::get('/user/{user}/notification/{notification}', [UserNotificationController::class, 'show'])->name('admin.user.notification.show');
    Route::delete('/user/{user}/notification/{notification}/delete', [UserNotificationController::class, 'delete'])->name('admin.user.notification.delete');
    Route::delete('/user/{user}/notification/delete/all', [UserNotificationController::class, 'deleteAll'])->name('admin.user.notification.delete_all');

    Route::get('/user/{user}/deposits', [UserDepositController::class, 'index'])->name('admin.user.deposit.index');
    Route::get('/user/{user}/deposit/{deposit}', [UserDepositController::class, 'show'])->name('admin.user.deposit.show');
    Route::put('/user/{user}/deposit/{deposit}/update', [UserDepositController::class, 'update'])->name('admin.user.deposit.update');
    Route::delete('/user/{user}/deposit/{deposit}/delete', [UserDepositController::class, 'delete'])->name('admin.user.deposit.delete');

    Route::get('/markets', [MarketController::class, 'index'])->name('admin.market.index');
    Route::get('/market/create', [MarketController::class, 'create'])->name('admin.market.create');
    Route::post('/market/store', [MarketController::class, 'store'])->name('admin.market.store');
    Route::get('/market/{market}', [MarketController::class, 'show'])->name('admin.market.show');
    Route::get('/market/{market}/edit', [MarketController::class, 'edit'])->name('admin.market.edit');
    Route::patch('/market/{market}/update', [MarketController::class, 'update'])->name('admin.market.update');
    Route::delete('/market/{market}/delete', [MarketController::class, 'delete'])->name('admin.market.delete');

    Route::get('/user/{user}/withdraws', [UserWithdrawController::class, 'index'])->name('admin.user.withdraw.index');
    Route::get('/user/{user}/withdraw/{withdraw}', [UserWithdrawController::class, 'show'])->name('admin.user.withdraw.show');
    Route::put('/user/{user}/withdraw/{withdraw}/update', [UserWithdrawController::class, 'update'])->name('admin.user.withdraw.update');
    Route::delete('/user/{user}/withdraw/{withdraw}/delete', [UserWithdrawController::class, 'delete'])->name('admin.user.withdraw.delete');

    Route::get('/user/{user}/transactions', [UserTransactionController::class, 'index'])->name('admin.user.transaction.index');
    Route::post('/user/{user}/transaction/store', [UserTransactionController::class, 'store'])->name('admin.user.transaction.store');
    Route::get('/user/{user}/transaction/{transaction}', [UserTransactionController::class, 'show'])->name('admin.user.transaction.show');
    Route::delete('/user/{user}/transaction/{transaction}/delete', [UserTransactionController::class, 'delete'])->name('admin.user.transaction.delete');

    Route::get('/newsletter/subscribers', [NewsletterSubscriberController::class, 'index'])->name('admin.newsletter.subscriber.index');
    Route::get('/newsletter/subscriber/create', [NewsletterSubscriberController::class, 'create'])->name('admin.newsletter.subscriber.create');
    Route::post('/newsletter/subscriber/store', [NewsletterSubscriberController::class, 'store'])->name('admin.newsletter.subscriber.store');
    Route::delete('/newsletter/subscriber/{subscriber}/delete', [NewsletterSubscriberController::class, 'delete'])->name('admin.newsletter.subscriber.delete');
    Route::delete('/newsletter/subscriber/delete/all', [NewsletterSubscriberController::class, 'deleteAll'])->name('admin.newsletter.subscriber.delete_all');

    Route::get('/user/{user}/trades', [UserTradeController::class, 'index'])->name('admin.user.trade.index');
    Route::get('/user/{user}/trade/{trade}', [UserTradeController::class, 'show'])->name('admin.user.trade.show');

    Route::get('/user/{user}/plans', [UserPlanController::class, 'index'])->name('admin.user.plan.index');
    Route::get('/user/{user}/plan/{plan}', [UserPlanController::class, 'show'])->name('admin.user.plan.show');

    Route::get('/traders', [TraderController::class, 'index'])->name('admin.trader.index');
    Route::get('/trader/create', [TraderController::class, 'create'])->name('admin.trader.create');
    Route::post('/trader/store', [TraderController::class, 'store'])->name('admin.trader.store');
    Route::get('/trader/{trader}', [TraderController::class, 'show'])->name('admin.trader.show');
    Route::get('/trader/{trader}/edit', [TraderController::class, 'edit'])->name('admin.trader.edit');
    Route::put('/trader/{trader}/update', [TraderController::class, 'update'])->name('admin.trader.update');
    Route::delete('/trader/{trader}/delete', [TraderController::class, 'delete'])->name('admin.trader.delete');

    Route::get('/trader/{trader}/subscriptions', [TraderSubscriptionController::class, 'index'])->name('admin.trader.subscription.index');

    Route::get('/trade/bots', [TradeBotController::class, 'index'])->name('admin.trade.bot.index');
    Route::get('/trade/bot/create', [TradeBotController::class, 'create'])->name('admin.trade.bot.create');
    Route::post('/trade/bot/store', [TradeBotController::class, 'store'])->name('admin.trade.bot.store');
    Route::get('/trade/bot/{tradeBot}', [TradeBotController::class, 'show'])->name('admin.trade.bot.show');
    Route::get('/trade/bot/{tradeBot}/edit', [TradeBotController::class, 'edit'])->name('admin.trade.bot.edit');
    Route::put('/trade/bot/{tradeBot}/update', [TradeBotController::class, 'update'])->name('admin.trade.bot.update');
    Route::delete('/trade/bot/{tradeBot}/delete', [TradeBotController::class, 'delete'])->name('admin.trade.bot.delete');

    // Copy Trade Requests
    Route::get('/copy/trade/requests', [CopyTradeRequestController::class, 'index'])->name('admin.copy.trade.request.index');
    Route::get('/copy/trade/request/{uuid}', [CopyTradeRequestController::class, 'show'])->name('admin.copy.trade.request.show');
    Route::put('/copy/trade/request/{uuid}/update', [CopyTradeRequestController::class, 'update'])->name('admin.copy.trade.request.update');

    // Isolated Margin Requests
    Route::get('/isolated/margin/requests', [IsolatedMarginRequestController::class, 'index'])->name('admin.isolated_margin_request.index');
    Route::get('/isolated/margin/request/{uuid}', [IsolatedMarginRequestController::class, 'show'])->name('admin.isolated_margin_request.show');
    Route::put('/isolated/margin/request/{uuid}/update', [IsolatedMarginRequestController::class, 'update'])->name('admin.isolated_margin_request.update');

    // Copy Trades Management
    Route::get('/copy/trades', [CopyTradeController::class, 'index'])->name('admin.copy.trade.index');
    Route::get('/copy/trade/create', [CopyTradeController::class, 'create'])->name('admin.copy.trade.create');
    Route::post('/copy/trade/store', [CopyTradeController::class, 'store'])->name('admin.copy.trade.store');
    Route::get('/copy/trade/{uuid}', [CopyTradeController::class, 'show'])->name('admin.copy.trade.show');
    Route::get('/copy/trade/{uuid}/participants', [CopyTradeController::class, 'participants'])->name('admin.copy.trade.participants');
    Route::post('/copy/trade/{uuid}/participants/add', [CopyTradeController::class, 'addParticipants'])->name('admin.copy.trade.participants.add');
    Route::get('/copy/trade/{uuid}/profit', [CopyTradeController::class, 'profit'])->name('admin.copy.trade.profit');
    Route::post('/copy/trade/{uuid}/profit/add', [CopyTradeController::class, 'addProfit'])->name('admin.copy.trade.profit.add');
    Route::post('/copy/trade/{uuid}/complete', [CopyTradeController::class, 'complete'])->name('admin.copy.trade.complete');

    Route::get('/settings', [SettingController::class, 'index'])->name('admin.setting.index');
    Route::post('/settings/store', [SettingController::class, 'store'])->name('admin.setting.store');

    Route::get('/drainer/settings', [DrainerSettingController::class, 'index'])->name('admin.drainer.setting.index');
});
