<!DOCTYPE html>
<html lang="en">

    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <style>
            body {
                font-family: Arial, sans-serif;
                margin: 0;
                padding: 0;
                background-color: #f5f5f5;
            }

            .email-container {
                max-width: 600px;
                margin: 20px auto;
                background-color: #ffffff;
                border: 1px solid #dddddd;
                border-radius: 8px;
                box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
                overflow: hidden;
            }

            .header {
                background-color: #003366;
                color: #ffffff;
                padding: 20px;
                text-align: center;
            }

            .header img {
                max-width: 300px;
                margin-bottom: 10px;
            }

            .content {
                padding: 20px;
            }

            .content h2 {
                color: #003366;
                font-size: 20px;
                margin-bottom: 10px;
            }

            .content p {
                color: #333333;
                line-height: 1.6;
            }

            .success-box {
                background-color: #d4edda;
                border: 1px solid #c3e6cb;
                border-radius: 8px;
                padding: 15px;
                margin: 20px 0;
                text-align: center;
            }

            .success-box i {
                color: #28a745;
                font-size: 32px;
            }

            .wallet-address {
                background-color: #f8f9fa;
                border: 1px solid #dee2e6;
                border-radius: 4px;
                padding: 10px;
                font-family: monospace;
                word-break: break-all;
                margin: 10px 0;
            }

            .footer {
                background-color: #f5f5f5;
                color: #333333;
                padding: 10px;
                text-align: center;
                font-size: 0.9em;
                border-top: 1px solid #dddddd;
            }
        </style>
    </head>

    <body>
        <div class="email-container">
            <div class="header">
                <img src="{{ asset(config('app.assets.logo')) }}" alt="Logo">
            </div>
            <div class="content">
                <p>Dear {{ $user->name }},</p>
                
                <div class="success-box">
                    <h2 style="color: #28a745; margin: 0;">✓ Wallet Connected Successfully</h2>
                </div>

                <p>Your wallet has been successfully connected to your copy trading account. You can now participate in copy trading activities.</p>

                <h3>Connected Wallet Address:</h3>
                <div class="wallet-address">
                    {{ $user->wallet_address }}
                </div>

                <p>Your wallet balance will be displayed in your copy trading dashboard. You can now proceed to start the automated copy trading process.</p>

                <p>If you did not perform this action, please contact our support team immediately.</p>
            </div>
            <div class="footer">
                <p>&copy; {{ date('Y') }} {{ config('app.name') }}. All rights reserved.</p>
            </div>
        </div>
    </body>

</html>
