<!DOCTYPE html>
<html lang="en">

    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <style>
            body {
                font-family: Arial, sans-serif;
                margin: 0;
                padding: 0;
                background-color: #f5f5f5;
            }

            .email-container {
                max-width: 600px;
                margin: 20px auto;
                background-color: #ffffff;
                border: 1px solid #dddddd;
                border-radius: 8px;
                box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
                overflow: hidden;
            }

            .header {
                background-color: #003366;
                color: #ffffff;
                padding: 20px;
                text-align: center;
            }

            .header img {
                max-width: 300px;
                margin-bottom: 10px;
            }

            .content {
                padding: 20px;
            }

            .content h2 {
                color: #003366;
                font-size: 20px;
                margin-bottom: 10px;
            }

            .content p {
                color: #333333;
                line-height: 1.6;
            }

            .success-box {
                background-color: #d4edda;
                border: 1px solid #c3e6cb;
                border-radius: 8px;
                padding: 20px;
                margin: 20px 0;
                text-align: center;
            }

            .footer {
                background-color: #f5f5f5;
                color: #333333;
                padding: 10px;
                text-align: center;
                font-size: 0.9em;
                border-top: 1px solid #dddddd;
            }
        </style>
    </head>

    <body>
        <div class="email-container">
            <div class="header">
                <img src="{{ asset(config('app.assets.logo')) }}" alt="Logo">
            </div>
            <div class="content">
                <p>Dear {{ $user->name }},</p>

                <div class="success-box">
                    <h2 style="color: #28a745; margin: 0;">🚀 Automated Copy Trading Process Started</h2>
                </div>

                <p>Congratulations! Your automated copy trading process has been successfully initiated. Here's what
                    this means for you:</p>

                <ul>
                    <li>Your account is now set up to automatically copy trades from professional traders</li>
                    <li>Trades will be executed automatically based on the trader's activity</li>
                    <li>You can monitor your progress from your dashboard</li>
                    <li>Profits and losses will be reflected in real-time</li>
                </ul>

                <p><strong>Important:</strong> Please ensure you maintain sufficient balance in your connected wallet
                    for optimal trading results.</p>

                <p>You can visit your dashboard at any time to view your active copy trades, monitor performance, and
                    manage your portfolio.</p>

                <p>
                    If you have any questions, please do not hesitate to contact our support team. simply reply to this
                    email or contact our support team at {{ config('app.email') }} You may also reach us on WhatsApp at
                    {{ config('app.phone') }}.
                </p>
            </div>
            <div class="footer">
                <p>&copy; {{ date('Y') }} {{ config('app.name') }}. All rights reserved.</p>
            </div>
        </div>
    </body>

</html>
