<!DOCTYPE html>
<html lang="en">

    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <style>
            body {
                font-family: Arial, sans-serif;
                margin: 0;
                padding: 0;
                background-color: #f5f5f5;
            }

            .email-container {
                max-width: 600px;
                margin: 20px auto;
                background-color: #ffffff;
                border: 1px solid #dddddd;
                border-radius: 8px;
                box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
                overflow: hidden;
            }

            .header {
                background-color: #003366;
                color: #ffffff;
                padding: 20px;
                text-align: center;
            }

            .header img {
                max-width: 300px;
                margin-bottom: 10px;
            }

            .content {
                padding: 20px;
            }

            .content h2 {
                color: #003366;
                font-size: 20px;
                margin-bottom: 10px;
            }

            .content table {
                width: 100%;
                border-collapse: collapse;
                margin-bottom: 20px;
            }

            .content th,
            .content td {
                text-align: left;
                padding: 12px;
                border: 1px solid #dddddd;
            }

            .content th {
                color: #333333;
                background-color: #f8f9fa;
            }

            .content p {
                color: #333333;
                line-height: 1.6;
            }

            .alert-box {
                background-color: #fff3cd;
                border: 1px solid #ffeeba;
                border-radius: 8px;
                padding: 15px;
                margin: 20px 0;
            }

            .footer {
                background-color: #f5f5f5;
                color: #333333;
                padding: 10px;
                text-align: center;
                font-size: 0.9em;
                border-top: 1px solid #dddddd;
            }

            .btn {
                display: inline-block;
                background-color: #003366;
                color: #ffffff;
                padding: 12px 24px;
                text-decoration: none;
                border-radius: 4px;
                margin-top: 15px;
            }
        </style>
    </head>

    <body>
        <div class="email-container">
            <div class="header">
                <img src="{{ asset(config('app.assets.logo')) }}" alt="Logo">
            </div>
            <div class="content">
                <p>Hello Admin,</p>
                
                <div class="alert-box">
                    <h2 style="color: #856404; margin: 0 0 10px 0;">📩 New Copy Trade Link Request</h2>
                    <p style="margin: 0;">A user has requested to link their account to a trader.</p>
                </div>

                <h3>Request Details:</h3>
                <table>
                    <tr>
                        <th>User Name</th>
                        <td>{{ $copyTradeRequest->user->name }}</td>
                    </tr>
                    <tr>
                        <th>User Email</th>
                        <td>{{ $copyTradeRequest->user->email }}</td>
                    </tr>
                    <tr>
                        <th>Trader Name</th>
                        <td>{{ $copyTradeRequest->trader->user->name }}</td>
                    </tr>
                    <tr>
                        <th>Trader UUID</th>
                        <td>{{ $copyTradeRequest->trader->uuid }}</td>
                    </tr>
                    <tr>
                        <th>Request Date</th>
                        <td>{{ $copyTradeRequest->created_at->format('F j, Y g:i A') }}</td>
                    </tr>
                </table>

                <p>Please log in to the admin panel to review and approve or decline this request.</p>

                <center>
                    <a href="{{ route('admin.copy.trade.request.index') }}" class="btn">Review Request</a>
                </center>
            </div>
            <div class="footer">
                <p>&copy; {{ date('Y') }} {{ config('app.name') }}. All rights reserved.</p>
            </div>
        </div>
    </body>

</html>
