<div class="row text-start">
    @include('partials.bootstrap_alert_livewire')

    {{-- Newsletter --}}
    <div class="col-sm-12 col-md-12 col-lg-6 mb-3">

        <h6 class="fw-semibold mb-2">STAY UPDATED</h6>
        <p class="text-muted fs-13 mb-3">
            Subscribe to our newsletter for market insights and exclusive offers.
        </p>

        <form wire:submit.prevent="subscribe">
            <div class="row">
                <div class="col-12">
                    <input type="email" wire:model.defer="email"
                        class="form-control form-control-sm @error('email') is-invalid @enderror"
                        placeholder="Enter your email">

                    <x-dashboard.input-error name="email" />

                </div>

                <div class="col-12 mt-1">
                    <button class="btn btn-primary btn-sm" wire:loading.attr="disabled">
                        <span wire:loading.remove>Subscribe</span>
                        <span wire:loading>Processing...</span>
                    </button>
                </div>

            </div>

        </form>

    </div>

    {{-- Contact Us --}}
    <div class="col-sm-12 col-md-12 col-lg-6 mb-3">
        <h6 class="fw-semibold mb-2">CONTACT US</h6>

        @if (config('app.phone'))
            <p class="text-muted fs-13 mb-2">
                Phone: <br>
                <span class="fw-medium">{{ config('app.phone') }}</span>
            </p>
        @endif

        @if (config('app.email'))
            <p class="text-muted fs-13 mb-0">
                Email: <br>
                <span class="fw-medium">{{ config('app.email') }}</span>
            </p>
        @endif
    </div>
</div>
