<div>
    <div class="auth-bg d-flex min-vh-100 justify-content-center align-items-center">
        <div class="row g-0 justify-content-center w-100 m-xxl-5 px-xxl-4 m-3">
            <div class="col-xl-4 col-lg-5 col-md-6">
                <div class="card overflow-hidden text-center h-100 p-xxl-4 p-3 mb-0">
                    @include('auth.layouts.header')
                   
                    <h3 class="fw-semibold mb-2">Create New Password</h3>

                    <p class="text-muted mb-2">Secure your account by setting a new password.</p>

                    <form class="text-start mb-3" wire:submit.prevent="resetPassword">
                        <!-- Password Reset Token -->
                        <input type="hidden" wire:model.defer="token" value="{{ $token }}">

                        <div class="mb-3">
                            <label class="form-label" for="email">Email</label>
                            <input type="email" wire:model.defer="email"
                                class="form-control @error('email') is-invalid @enderror" placeholder="Enter your email"
                                value="{{ old('email', $email) }}" required autofocus autocomplete="username">
                            @error('email')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label class="form-label" for="password">Create New Password <small
                                    class="text-primary ms-1">Must be at least 8 characters</small></label>
                            <input type="password" wire:model.defer="password"
                                class="form-control @error('password') is-invalid @enderror"
                                placeholder="New Password" required autocomplete="new-password">
                            @error('password')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="mb-3">
                            <label class="form-label" for="password_confirmation">Reenter New Password</label>
                            <input type="password" wire:model.defer="password_confirmation"
                                class="form-control @error('password_confirmation') is-invalid @enderror"
                                placeholder="Reenter Password" required autocomplete="new-password">
                            @error('password_confirmation')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="mb-2 d-grid">
                            <button type="submit" class="btn btn-primary" wire:loading.attr="disabled">
                                <span wire:loading.remove>Create New Password</span>
                                <span wire:loading>Processing...</span>
                            </button>
                        </div>

                    </form>

                    <p class="text-danger fs-14 mb-4">Back To <a href="{{ route('login') }}"
                            class="fw-semibold text-dark ms-1">Login !</a></p>

                    @include('auth.layouts.footer')
                </div>
            </div>
        </div>
    </div>
</div>
