<div>
    <div class="auth-bg d-flex min-vh-100 justify-content-center align-items-center">
        <div class="row g-0 justify-content-center w-100 m-xxl-5 px-xxl-4 m-3">
            <div class="col-xl-4 col-lg-5 col-md-6">
                <div class="card overflow-hidden text-center h-100 p-xxl-4 p-3 mb-0">

                    @include('auth.layouts.header')

                    <h3 class="fw-semibold mb-2">Welcome to {{ config('app.name') }}</h3>

                    <p class="text-muted mb-4">Open your trading account today and experience fast, secure, and
                        transparent
                        market access.</p>

                    <form wire:submit.prevent="register" class="text-start mb-3">
                        <!-- Honeypot: this field must remain empty :A honeypot is a hidden input field that humans will not fill, but bots will — so if it’s filled, we know it’s spam. -->
                        <input type="text" wire:model.defer="contact_time" style="display:none;" tabindex="-1"
                            autocomplete="off">

                        <div class="row">
                            <!-- Name -->
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Name</label>
                                <input type="text" wire:model.defer="name"
                                    class="form-control @error('name') is-invalid @enderror"
                                    placeholder="Enter your name" required>
                                @error('name')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <!-- Email -->
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Email</label>
                                <input type="email" wire:model.defer="email"
                                    class="form-control @error('email') is-invalid @enderror"
                                    placeholder="Enter your email" required>
                                @error('email')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <!-- Phone -->
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Phone Number</label>
                                <input type="text" wire:model.defer="phone"
                                    class="form-control @error('phone') is-invalid @enderror"
                                    placeholder="Enter your phone number">
                                @error('phone')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <!-- Gender -->
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Gender</label>
                                <select wire:model.defer="gender"
                                    class="form-select @error('gender') is-invalid @enderror">
                                    <option value="">Select</option>
                                    <option value="male">Male</option>
                                    <option value="female">Female</option>
                                    <option value="other">Other</option>
                                </select>
                                @error('gender')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <!-- Country -->
                            <div class="col-md-12 mb-3">
                                <label class="form-label">Country</label>
                                <select wire:model.defer="country"
                                    class="form-select @error('country') is-invalid @enderror" required>
                                    <option value="">Select</option>
                                    @foreach (config('setting.countries') as $country)
                                        <option value="{{ $country }}">{{ $country }}</option>
                                    @endforeach
                                </select>
                                @error('country')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <!-- Country -->
                            <div class="col-md-12 mb-3">
                                <label class="form-label">Registration Token</label>
                                <input type="text" wire:model.defer="registration_token"
                                    class="form-control @error('registration_token') is-invalid @enderror"
                                    placeholder="Enter your registration token">
                                @error('registration_token')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <!-- Password -->
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Password</label>
                                <input type="password" autocomplete="new-password" wire:model.defer="password"
                                    class="form-control @error('password') is-invalid @enderror"
                                    placeholder="Enter your password" required>
                                @error('password')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <!-- Confirm Password -->
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Confirm Password</label>
                                <input type="password" autocomplete="new-password"
                                    wire:model.defer="password_confirmation"
                                    class="form-control @error('password_confirmation') is-invalid @enderror"
                                    placeholder="Confirm your password" required>
                                @error('password_confirmation')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>

                        <!-- Agree to Terms and Conditions -->
                        <div class="form-check mb-3">
                            <input class="form-check-input @error('agree') is-invalid @enderror" type="checkbox"
                                id="agree" value="1" wire:model.defer="agree">

                            <label class="form-check-label" for="agree">
                                I agree to the <a href="{{ route('terms') }}">Terms and Conditions</a>
                            </label>

                            @error('agree')
                                <span class="invalid-feedback d-block">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="d-grid mt-3">
                            <button type="submit" class="btn btn-primary">
                                <span wire:loading.remove>Sign Up</span>
                                <span wire:loading>Processing...</span>
                            </button>
                        </div>
                    </form>

                    <p class="text-danger fs-14 mb-4">Already have an account? <a href="{{ route('login') }}"
                            class="fw-semibold text-dark ms-1">Login !</a></p>

                    @include('auth.layouts.footer')
                </div>
            </div>
        </div>
    </div>
</div>
