<div>
    <div class="auth-bg d-flex min-vh-100 justify-content-center align-items-center">
        <div class="row g-0 justify-content-center w-100 m-xxl-5 px-xxl-4 m-3">
            <div class="col-xl-4 col-lg-5 col-md-6">
                <div class="card overflow-hidden text-center h-100 p-xxl-4 p-3 mb-0">
                    @include('auth.layouts.header')

                    <h3 class="fw-semibold mb-2">Forgot Your Password?</h3>

                    <p class="text-muted mb-4">We get it, stuff happens. Just enter your email address below and we'll
                        send you a link to reset your password!</p>

                    <form wire:submit.prevent="forgotPassword" class="text-start mb-3">

                        <div class="mb-3">
                            <label class="form-label" for="email">Email</label>
                            <input type="email" wire:model.defer="email"
                                class="form-control @error('email') is-invalid @enderror" placeholder="Enter your email" required
                                autofocus>

                            @error('email')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="d-grid">
                            <button  type="submit" class="btn btn-primary">
                                <span wire:loading.remove>Email Password Reset Link</span>
                                <span wire:loading>Processing...</span>
                            </button>
                        </div>
                    </form>

                    <p class="text-danger fs-14 mb-4">Back To <a href="{{ route('login') }}"
                            class="fw-semibold text-dark ms-1">Login !</a></p>

                    @include('auth.layouts.footer')
                </div>
            </div>
        </div>
    </div>
</div>
