@extends('frontend.layouts.app')
@section('content')
    @include('frontend.pages.partials.page_title')

    <section id="content">
        <div class="content-wrap p-4 m-4">
            <div class="section notopborder nomargin header-stick">
                <div class="container clearfix">

                    <div class="col-md-10 col-sm-10">
                        <div class="mb-5">
                            <p class="lead text-muted">
                                <strong>Last Updated: {{ \Carbon\Carbon::now()->format('F d, Y') }}</strong>
                            </p>
                        </div>

                        <!-- 1. Introduction -->
                        <div class="mb-5">
                            <h3 class="fw-bold mb-3"><span class="text-primary">1.</span> Introduction</h3>
                            <p>
                                This privacy notice applies to the processing activities performed by the Company to the
                                personal data of its clients, prospective clients, and website visitors.
                            </p>
                            <p>
                                Your privacy is of the utmost importance to us. It is our policy to safeguard the
                                confidentiality of information and respect the privacy of individuals.
                            </p>
                            <p>
                                Please see below for information about how we manage personal data, and for information
                                about your rights with respect to the processing of your personal data.
                            </p>
                        </div>

                        <!-- 2. Definitions -->
                        <div class="mb-5">
                            <h3 class="fw-bold mb-3"><span class="text-primary">2.</span> Definitions</h3>
                            <p>The following terms are defined as follows:</p>
                            <ul class="list-unstyled ms-4">
                                <li class="mb-2"><strong>2.1 “AML”</strong> means anti-money laundering.</li>
                                <li class="mb-2"><strong>2.2 “Digital Asset”</strong> means any digital representation of
                                    value that may be traded via the platform, excluding non-fungible tokens.</li>
                                <li class="mb-2"><strong>2.3 “We”, “Us”, “Our”, “Company”</strong> refers collectively to
                                    the operating entity providing the services.</li>
                                <li class="mb-2"><strong>2.4 “Personal data”</strong> refers to any information relating
                                    to an identified or identifiable natural person, including names, identification
                                    numbers, location data, an online identifier, or to one or more factors specific to the
                                    physical, economic, cultural or social identity of a natural person.</li>
                            </ul>
                        </div>

                        <!-- 3. Your Data Controller -->
                        <div class="mb-5">
                            <h3 class="fw-bold mb-3"><span class="text-primary">3.</span> Your Data Controller</h3>
                            <p>
                                Our products and services are provided through local operating entities. You are contracting
                                with the Company as specified in our <a href="{{ route('terms') }}"
                                    class="text-primary fw-bold">Terms & Conditions</a>.
                            </p>
                            <p>
                                The platform you are contracting with is your <strong>Data Controller</strong> and is
                                responsible for the collection, use, disclosure, retention, and protection of your personal
                                data in accordance with our global privacy standards.
                            </p>
                        </div>

                        <!-- 4. How do we protect personal data? -->
                        <div class="mb-5">
                            <h3 class="fw-bold mb-3"><span class="text-primary">4.</span> How Do We Protect Personal Data?
                            </h3>
                            <p>
                                The Company takes the security of personal data incredibly seriously.
                            </p>
                            <div class="p-4 bg-light border-start border-primary border-4 rounded">
                                <p class="mb-0">
                                    We implement appropriate technical and organizational measures to ensure a level of
                                    security appropriate to the risk, including encryption, access controls, regular
                                    security assessments, and employee training.
                                </p>
                            </div>
                        </div>

                        <!-- 5. Information we may collect about you -->
                        <div class="mb-5">
                            <h3 class="fw-bold mb-3"><span class="text-primary">5.</span> Information We May Collect About
                                You</h3>
                            <p>
                                We obtain information about you through your use of our products, services, websites,
                                account opening process, event/news subscriptions, and ongoing support communications.
                            </p>
                            <p>
                                To open an account, you must complete a “create account” form. By doing so, you disclose
                                personal data to enable us to assess your application and comply with applicable laws.
                            </p>
                            <p class="text-danger fw-bold">
                                The minimum information required to enter into a contract and comply with anti-money
                                laundering and fraud prevention laws is <em>“Biographical information and contact
                                    information”</em> and <em>“Verification information”</em>. Without this, we cannot
                                provide services.
                            </p>

                            <h5 class="mt-4 fw-bold">Information collected from you:</h5>
                            <ul class="list-unstyled ms-4">
                                <li class="mb-2"><strong>Full name, contact details</strong> (email, phone), date of
                                    birth, place of birth, gender, citizenship <em>(“Biographical information and contact
                                        information”)</em>;</li>
                                <li class="mb-2"><strong>Trading account balances, activity</strong>, inquiries and
                                    responses <em>(“Trading information”)</em>;</li>
                                <li class="mb-2"><strong>Verification information</strong>: passport, driver’s license,
                                    selfie photos/videos, login credentials, government ID (may involve biometric data
                                    extraction);</li>
                                <li class="mb-2"><strong>Other information</strong>: any data we deem necessary to comply
                                    with AML or legal obligations.</li>
                            </ul>

                            <h5 class="mt-4 fw-bold">Automatically collected information:</h5>
                            <ul class="list-unstyled ms-4">
                                <li class="mb-2"><strong>Browser information</strong>: IP address, domain, referrer, login
                                    data, browser type/version, time zone, plugins, OS, platform;</li>
                                <li class="mb-2"><strong>Log information</strong>: device ID, OS, model, storage, MAC
                                    address, SIM data, user behavior signals, location, network, URL clickstream, page
                                    interactions, timestamps, errors.</li>
                            </ul>

                            <h5 class="mt-4 fw-bold">Information from third parties:</h5>
                            <p>
                                We may receive data from payment providers, AML/fraud service providers, business partners,
                                advertising networks, credit agencies, and public sources (e.g., blockchain data).
                            </p>
                        </div>

                        <!-- 6. Disclosure of your personal data -->
                        <div class="mb-5">
                            <h3 class="fw-bold mb-3"><span class="text-primary">6.</span> Disclosure of Your Personal Data
                            </h3>
                            <p>
                                We may disclose your personal data to group companies, service providers, and business
                                partners for legitimate purposes (e.g., administrative, IT, legal, compliance, analytics).
                            </p>
                            <p>
                                Third parties we share with are required to protect your data and comply with privacy laws.
                                We may also disclose data when compelled by law (e.g., court order).
                            </p>
                        </div>

                        <!-- 7. Where we store your personal data -->
                        <div class="mb-5">
                            <h3 class="fw-bold mb-3"><span class="text-primary">7.</span> Where We Store Your Personal Data
                            </h3>
                            <p>
                                Data is stored on secure servers and infrastructure. International transfers occur only with
                                appropriate safeguards.
                            </p>
                        </div>

                        <!-- 8. Data retention -->
                        <div class="mb-5">
                            <h3 class="fw-bold mb-3"><span class="text-primary">8.</span> Data Retention</h3>
                            <p>
                                We retain personal data only as long as necessary for legal, regulatory, or business
                                purposes.
                            </p>
                            <p>
                                Under AML laws, we retain due diligence records and transaction evidence for <strong>at
                                    least 5 years</strong> after the relationship ends.
                            </p>
                            <p>
                                Opt-out requests are stored on a suppression list to prevent future marketing.
                            </p>
                        </div>

                        <!-- 9. Cookies -->
                        <div class="mb-5">
                            <h3 class="fw-bold mb-3"><span class="text-primary">9.</span> Cookies</h3>
                            <p>
                                Cookies are small text files that enhance your experience. You can control cookie settings
                                in your browser, though some features may be limited.
                            </p>
                        </div>

                        <!-- 10. Privacy when using digital assets and blockchains -->
                        <div class="mb-5">
                            <h3 class="fw-bold mb-3"><span class="text-primary">10.</span> Privacy When Using Digital Assets
                                and Blockchains</h3>
                            <p>
                                Transactions on public blockchains are immutable and may be analyzed to reveal personal data
                                when combined with other sources.
                            </p>
                            <p class="text-warning fw-bold">
                                We cannot erase, modify, or alter data recorded on public blockchains.
                            </p>
                        </div>

                        <!-- 11. Your rights regarding your personal data -->
                        <div class="mb-5">
                            <h3 class="fw-bold mb-3"><span class="text-primary">11.</span> Your Rights Regarding Your
                                Personal Data</h3>
                            <p>
                                You have the following rights (subject to legal limitations):
                            </p>

                            <div class="row g-3">
                                <div class="col-md-6">
                                    <div class="border p-3 rounded h-100">
                                        <h6 class="fw-bold text-primary">Access</h6>
                                        <p class="small mb-0">Request confirmation and a copy of your data.</p>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="border p-3 rounded h-100">
                                        <h6 class="fw-bold text-primary">Rectification</h6>
                                        <p class="small mb-0">Correct inaccurate or incomplete data.</p>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="border p-3 rounded h-100">
                                        <h6 class="fw-bold text-primary">Erasure</h6>
                                        <p class="small mb-0">Request deletion where retention is not required.</p>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="border p-3 rounded h-100">
                                        <h6 class="fw-bold text-primary">Data Portability</h6>
                                        <p class="small mb-0">Receive your data in a structured format.</p>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="border p-3 rounded h-100">
                                        <h6 class="fw-bold text-primary">Objection</h6>
                                        <p class="small mb-0">Object to processing based on legitimate interests or
                                            marketing.</p>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="border p-3 rounded h-100">
                                        <h6 class="fw-bold text-primary">Withdraw Consent</h6>
                                        <p class="small mb-0">Withdraw consent at any time (does not affect prior
                                            processing).</p>
                                    </div>
                                </div>
                            </div>

                            <div class="mt-4">
                                <h6 class="fw-bold">Complaints</h6>
                                <p>
                                    Contact us first at <a href="mailto:{{ config('app.email') }}"
                                        class="text-primary">{{ config('app.email') }}</a>. You may escalate to a data
                                    protection authority.
                                </p>
                            </div>
                        </div>

                        <!-- 12. Contact information -->
                        <div class="mb-5">
                            <h3 class="fw-bold mb-3"><span class="text-primary">12.</span> Contact Information</h3>
                            <div class="p-4 bg-light border rounded">
                                <p class="mb-1">
                                    <strong>Email:</strong> <a
                                        href="mailto:{{ config('app.email') }}">{{ config('app.email') }}</a>
                                </p>
                                <p class="mb-0">
                                    <strong>Data Protection Officer:</strong> <a
                                        href="mailto:{{ config('app.email') }}">{{ config('app.email') }}</a>
                                </p>
                            </div>
                        </div>

                        <!-- 13. Data Protection Authorities -->
                        <div class="mb-5">
                            <h3 class="fw-bold mb-3"><span class="text-primary">13.</span> Data Protection Authorities
                            </h3>
                            <p>
                                If unsatisfied with our response, you may contact your local data protection authority.
                            </p>

                        </div>
                    </div>

                </div>
            </div>
        </div>
    </section>
@endsection
