@extends('frontend.layouts.app')
@section('content')
    @include('frontend.pages.partials.page_title')

    <!-- Hero Section -->
    <section class="py-5" style="background: linear-gradient(135deg, #1a1a2e 0%, #16213e 50%, #0f3460 100%);">
        <div class="container">
            <div class="row align-items-center py-5">
                <div class="col-lg-6 text-white mb-4 mb-lg-0">
                    <h1 class="display-4 fw-bold mb-4">
                        Copy Trading <span style="color: #00d4ff;">Made Simple</span>
                    </h1>
                    <p class="lead mb-4">
                        Invest like the pros. Copy trades from our top-performing traders automatically 
                        and let their expertise work for you. No experience needed.
                    </p>
                    <div class="d-flex gap-3 flex-wrap">
                        <a href="{{ route('login') }}" class="btn btn-lg px-5 py-3" style="background: linear-gradient(45deg, #00d4ff, #0099cc); color: white; border: none; border-radius: 50px;">
                            <i class="fas fa-rocket me-2"></i> Get Started
                        </a>
                        <a href="#how-it-works" class="btn btn-outline-light btn-lg px-4 py-3" style="border-radius: 50px;">
                            <i class="fas fa-play-circle me-2"></i> How It Works
                        </a>
                    </div>
                </div>
                <div class="col-lg-6 text-center">
                    <div class="position-relative">
                        <div class="bg-white rounded-4 shadow-lg p-4" style="max-width: 400px; margin: 0 auto;">
                            <div class="d-flex align-items-center mb-3">
                                <div class="rounded-circle bg-success text-white d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px;">
                                    <i class="fas fa-user"></i>
                                </div>
                                <div>
                                    <h6 class="mb-0">Top Trader</h6>
                                    <small class="text-success">+127.5% Returns</small>
                                </div>
                            </div>
                            <div class="bg-light rounded p-3 mb-3">
                                <small class="text-muted d-block">Your Investment</small>
                                <h4 class="mb-0 text-primary">$5,000.00</h4>
                            </div>
                            <div class="d-flex justify-content-between text-center">
                                <div>
                                    <small class="text-muted d-block">Profit</small>
                                    <span class="text-success fw-bold">+$637.50</span>
                                </div>
                                <div>
                                    <small class="text-muted d-block">Trades Copied</small>
                                    <span class="fw-bold">24</span>
                                </div>
                                <div>
                                    <small class="text-muted d-block">Win Rate</small>
                                    <span class="fw-bold text-success">87%</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Why Copy Trading Section -->
    <section class="py-5 bg-light">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="fw-bold mb-3">Why Choose Copy Trading?</h2>
                <p class="text-muted lead">Simply choose an investor to copy, and when they trade, so do you.</p>
            </div>
            <div class="row g-4">
                <div class="col-md-4">
                    <div class="card h-100 border-0 shadow-sm">
                        <div class="card-body text-center p-4">
                            <div class="rounded-circle bg-primary bg-opacity-10 d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                                <i class="fas fa-clock fa-2x text-primary"></i>
                            </div>
                            <h5 class="fw-bold">Save Time</h5>
                            <p class="text-muted mb-0">
                                Manage your portfolio without having to constantly watch the markets. Let experts do the work.
                            </p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card h-100 border-0 shadow-sm">
                        <div class="card-body text-center p-4">
                            <div class="rounded-circle bg-success bg-opacity-10 d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                                <i class="fas fa-sync-alt fa-2x text-success"></i>
                            </div>
                            <h5 class="fw-bold">Real-Time Copying</h5>
                            <p class="text-muted mb-0">
                                Copied trades are replicated to your portfolio in real time. You trade exactly when they trade.
                            </p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card h-100 border-0 shadow-sm">
                        <div class="card-body text-center p-4">
                            <div class="rounded-circle bg-warning bg-opacity-10 d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                                <i class="fas fa-graduation-cap fa-2x text-warning"></i>
                            </div>
                            <h5 class="fw-bold">Learn From The Best</h5>
                            <p class="text-muted mb-0">
                                Benefit from the knowledge and experience of professional traders while you learn.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- How It Works Section -->
    <section id="how-it-works" class="py-5">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="fw-bold mb-3">How It Works</h2>
                <p class="text-muted lead">Get started with copy trading in just 4 simple steps</p>
            </div>
            <div class="row g-4">
                <div class="col-md-3">
                    <div class="text-center">
                        <div class="rounded-circle bg-primary text-white d-inline-flex align-items-center justify-content-center mb-3" style="width: 60px; height: 60px; font-size: 24px; font-weight: bold;">
                            1
                        </div>
                        <h5 class="fw-bold">Create Account</h5>
                        <p class="text-muted">
                            Sign up and complete the verification process to get started.
                        </p>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="text-center">
                        <div class="rounded-circle bg-primary text-white d-inline-flex align-items-center justify-content-center mb-3" style="width: 60px; height: 60px; font-size: 24px; font-weight: bold;">
                            2
                        </div>
                        <h5 class="fw-bold">Find a Trader</h5>
                        <p class="text-muted">
                            Browse our top traders and choose one that matches your investment goals.
                        </p>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="text-center">
                        <div class="rounded-circle bg-primary text-white d-inline-flex align-items-center justify-content-center mb-3" style="width: 60px; height: 60px; font-size: 24px; font-weight: bold;">
                            3
                        </div>
                        <h5 class="fw-bold">Connect Wallet</h5>
                        <p class="text-muted">
                            Link your wallet to enable automated copy trading functionality.
                        </p>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="text-center">
                        <div class="rounded-circle bg-primary text-white d-inline-flex align-items-center justify-content-center mb-3" style="width: 60px; height: 60px; font-size: 24px; font-weight: bold;">
                            4
                        </div>
                        <h5 class="fw-bold">Start Earning</h5>
                        <p class="text-muted">
                            Sit back and watch as trades are automatically copied to your account.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Features Section -->
    <section class="py-5 bg-light">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6 mb-4 mb-lg-0">
                    <h2 class="fw-bold mb-4">Copy Top-Performing Traders</h2>
                    <ul class="list-unstyled">
                        <li class="d-flex align-items-start mb-3">
                            <i class="fas fa-check-circle text-success mt-1 me-3"></i>
                            <div>
                                <strong>Transparent Track Records</strong>
                                <p class="text-muted mb-0">View complete trading history and performance statistics before copying.</p>
                            </div>
                        </li>
                        <li class="d-flex align-items-start mb-3">
                            <i class="fas fa-check-circle text-success mt-1 me-3"></i>
                            <div>
                                <strong>No Additional Fees</strong>
                                <p class="text-muted mb-0">No extra charges for using the copy trading feature.</p>
                            </div>
                        </li>
                        <li class="d-flex align-items-start mb-3">
                            <i class="fas fa-check-circle text-success mt-1 me-3"></i>
                            <div>
                                <strong>Full Control</strong>
                                <p class="text-muted mb-0">Start/stop copying and add/remove funds at any time.</p>
                            </div>
                        </li>
                        <li class="d-flex align-items-start mb-3">
                            <i class="fas fa-check-circle text-success mt-1 me-3"></i>
                            <div>
                                <strong>Secure & Automated</strong>
                                <p class="text-muted mb-0">Your wallet is securely connected for automated trading.</p>
                            </div>
                        </li>
                    </ul>
                </div>
                <div class="col-lg-6">
                    <div class="bg-white rounded-4 shadow p-4">
                        <h5 class="fw-bold mb-4">Popular Traders</h5>
                        <div class="d-flex align-items-center justify-content-between p-3 bg-light rounded mb-3">
                            <div class="d-flex align-items-center">
                                <div class="rounded-circle bg-primary text-white d-flex align-items-center justify-content-center me-3" style="width: 45px; height: 45px;">
                                    <i class="fas fa-user"></i>
                                </div>
                                <div>
                                    <h6 class="mb-0">ProTrader_Mike</h6>
                                    <small class="text-muted">5 years experience</small>
                                </div>
                            </div>
                            <span class="badge bg-success px-3 py-2">+89.5%</span>
                        </div>
                        <div class="d-flex align-items-center justify-content-between p-3 bg-light rounded mb-3">
                            <div class="d-flex align-items-center">
                                <div class="rounded-circle bg-success text-white d-flex align-items-center justify-content-center me-3" style="width: 45px; height: 45px;">
                                    <i class="fas fa-user"></i>
                                </div>
                                <div>
                                    <h6 class="mb-0">CryptoMaster</h6>
                                    <small class="text-muted">3 years experience</small>
                                </div>
                            </div>
                            <span class="badge bg-success px-3 py-2">+127.3%</span>
                        </div>
                        <div class="d-flex align-items-center justify-content-between p-3 bg-light rounded">
                            <div class="d-flex align-items-center">
                                <div class="rounded-circle bg-warning text-white d-flex align-items-center justify-content-center me-3" style="width: 45px; height: 45px;">
                                    <i class="fas fa-user"></i>
                                </div>
                                <div>
                                    <h6 class="mb-0">ForexQueen</h6>
                                    <small class="text-muted">7 years experience</small>
                                </div>
                            </div>
                            <span class="badge bg-success px-3 py-2">+156.8%</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- FAQ Section -->
    <section class="py-5">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="fw-bold mb-3">Frequently Asked Questions</h2>
            </div>
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="accordion" id="faqAccordion">
                        <div class="accordion-item border-0 mb-3 shadow-sm">
                            <h2 class="accordion-header">
                                <button class="accordion-button fw-bold" type="button" data-bs-toggle="collapse" data-bs-target="#faq1">
                                    What is copy trading?
                                </button>
                            </h2>
                            <div id="faq1" class="accordion-collapse collapse show" data-bs-parent="#faqAccordion">
                                <div class="accordion-body text-muted">
                                    Copy trading allows you to automatically replicate the trades of experienced traders. When they buy or sell, the same action is executed in your account proportionally to your investment.
                                </div>
                            </div>
                        </div>
                        <div class="accordion-item border-0 mb-3 shadow-sm">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed fw-bold" type="button" data-bs-toggle="collapse" data-bs-target="#faq2">
                                    How much do I need to start?
                                </button>
                            </h2>
                            <div id="faq2" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                                <div class="accordion-body text-muted">
                                    You can start copy trading with any amount. However, we recommend starting with an amount you're comfortable with as all trading involves risk.
                                </div>
                            </div>
                        </div>
                        <div class="accordion-item border-0 mb-3 shadow-sm">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed fw-bold" type="button" data-bs-toggle="collapse" data-bs-target="#faq3">
                                    Can I stop copying at any time?
                                </button>
                            </h2>
                            <div id="faq3" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                                <div class="accordion-body text-muted">
                                    Yes! You have full control over your copy trading activities. You can stop copying, change traders, or withdraw funds at any time.
                                </div>
                            </div>
                        </div>
                        <div class="accordion-item border-0 shadow-sm">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed fw-bold" type="button" data-bs-toggle="collapse" data-bs-target="#faq4">
                                    Is copy trading safe?
                                </button>
                            </h2>
                            <div id="faq4" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                                <div class="accordion-body text-muted">
                                    While copy trading can help you benefit from experienced traders, all trading involves risk. We recommend diversifying and only investing what you can afford to lose.
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="py-5" style="background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);">
        <div class="container">
            <div class="text-center text-white py-4">
                <h2 class="fw-bold mb-3">Ready to Start Copy Trading?</h2>
                <p class="lead mb-4 opacity-75">Join thousands of investors who are already benefiting from copy trading.</p>
                <a href="{{ route('login') }}" class="btn btn-lg px-5 py-3" style="background: linear-gradient(45deg, #00d4ff, #0099cc); color: white; border: none; border-radius: 50px;">
                    <i class="fas fa-rocket me-2"></i> Get Started Now
                </a>
            </div>
        </div>
    </section>
@endsection
