@extends('dashboard.user.layouts.app')
@section('content')
    <style>
        .withdrawal-option {
            transition: all 0.25s ease;
        }

        .withdrawal-option:hover {
            transform: translateY(-4px);
            box-shadow: 0 10px 25px rgba(0, 0, 0, .08);
        }
    </style>

    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <div class="col-12">

                <div class="row justify-content-center">
                    <div class="col-lg-8 col-md-10">

                        <div class="text-center mb-4">
                            <h4 class="fw-semibold">Choose Withdrawal Method</h4>
                            <p class="text-muted">
                                Select how you would like to receive your funds.
                            </p>
                        </div>

                        <div class="row g-4">
                            <!-- Crypto Withdrawal -->
                            <div class="col-md-6">
                                <a href="{{ route('user.withdraw.method.crypto') }}" class="text-decoration-none">
                                    <div class="card h-100 shadow-sm border-0 withdrawal-option">
                                        <div class="card-body text-center">
                                            <i class="ti ti-wallet fs-1 text-primary mb-3"></i>
                                            <h5 class="mb-1">Crypto Wallet</h5>
                                            <p class="text-muted small mb-0">
                                                Withdraw directly to a cryptocurrency wallet.
                                            </p>
                                        </div>
                                    </div>
                                </a>
                            </div>

                            @if (config('app.use_bank_withdraw_method'))
                                <!-- Bank Withdrawal -->
                                <div class="col-md-6">
                                    <a href="{{ route('user.withdraw.method.bank') }}" class="text-decoration-none">
                                        <div class="card h-100 shadow-sm border-0 withdrawal-option">
                                            <div class="card-body text-center">
                                                <i class="ti ti-building-bank fs-1 text-success mb-3"></i>
                                                <h5 class="mb-1">Bank Account</h5>
                                                <p class="text-muted small mb-0">
                                                    Withdraw funds to your registered bank account.
                                                </p>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                            @endif
                        </div>

                    </div>
                </div>

            </div>
        </div>

    </div>
@endsection
