@extends('dashboard.user.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <div class="col-12">

                <x-dashboard.card title="{{ $title }}" :button="[
                    'route' => route('user.withdraw.method'),
                    'text' => 'Withdraw',
                    'icon' => 'fa fa-plus me-1',
                ]">

                    <div class="table-responsive d-none d-md-block">
                        <table id="myTable" class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Reference ID</th>
                                    <th>Amount</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($transactions as $transaction)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>
                                            {{ $transaction->reference_id }}
                                        </td>
                                        <td>{{ currency($user->currency) }}{{ formatAmount($transaction->amount) }}
                                        </td>
                                        <td>
                                            <span class="{{ $transaction->status->badge() }}">
                                                {{ $transaction->status->label() }}
                                            </span>
                                        </td>
                                        <td>
                                            <a href="{{ route('user.withdraw.show', $transaction->uuid) }}"
                                                class="btn btn-info btn-sm"> <i class="fa fa-file-text me-1"></i> View</a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    <div class="d-block d-md-none">
                        @foreach ($transactions as $transaction)
                            <div class="card mb-3 shadow-sm">
                                <div class="card-body">
                                    <h5 class="card-title">
                                        <strong> Reference ID:</strong>
                                        {{ $transaction->reference_id }}
                                    </h5>

                                    <p class="mb-1"><strong>Amount:</strong>
                                        {{ currency($user->currency) }}{{ formatAmount($transaction->amount) }}
                                    </p>
                                    <p class="mb-2"><strong>Status:</strong>
                                        <span class="{{ $transaction->status->badge() }}">
                                            {{ $transaction->status->label() }}
                                        </span>
                                    </p>

                                    <div class="d-flex gap-2">
                                        <a href="{{ route('user.withdraw.show', $transaction->uuid) }}"
                                            class="btn btn-info btn-sm"> <i class="fa fa-file-text me-1"></i>
                                            View</a>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>

                </x-dashboard.card>

            </div>
        </div>

    </div>
@endsection
