@extends('dashboard.user.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <!-- Total Portfolio Value -->
        <div class="row mb-3">
            <div class="col-12">
                <x-dashboard.card>
                    <div class="text-center py-3">
                        <small class="text-muted d-block mb-2">Total Portfolio Value</small>
                        <h2 class="mb-0 fw-bold">${{ number_format($totalValueUSD, 2) }}</h2>
                        <small class="text-muted">USD</small>
                    </div>
                </x-dashboard.card>
            </div>
        </div>

        <!-- Balances List -->
        <div class="row">
            <div class="col-12">
                <x-dashboard.card title="My Balances">
                    
                    <div class="table-responsive">
                        <table class="table table-hover align-middle">
                            <thead>
                                <tr>
                                    <th>Asset</th>
                                    <th class="text-end">Balance</th>
                                    <th class="text-end">Price (USD)</th>
                                    <th class="text-end">Value (USD)</th>
                                    <th class="text-center">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($balances as $balance)
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="crypto-icon me-2">
                                                    <span class="badge bg-primary rounded-circle" style="width: 35px; height: 35px; display: flex; align-items: center; justify-content: center;">
                                                        {{ $balance['symbol'] }}
                                                    </span>
                                                </div>
                                                <div>
                                                    <strong>{{ $balance['market']->asset }}</strong>
                                                    <br>
                                                    <small class="text-muted">{{ $balance['market']->symbol }}</small>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="text-end">
                                            <strong>{{ formatAmount($balance['balance']) }}</strong>
                                            <br>
                                            <small class="text-muted">{{ $balance['symbol'] }}</small>
                                        </td>
                                        <td class="text-end">
                                            <span class="text-muted">${{ number_format($balance['price_usd'], 2) }}</span>
                                        </td>
                                        <td class="text-end">
                                            <strong class="text-primary">${{ number_format($balance['value_usd'], 2) }}</strong>
                                        </td>
                                        <td class="text-center">
                                            <div class="btn-group btn-group-sm" role="group">
                                                <a href="{{ route('user.deposit.index') }}" class="btn btn-outline-success btn-sm" title="Deposit">
                                                    <i class="fas fa-arrow-down"></i>
                                                </a>
                                                <a href="{{ route('user.withdraw.index') }}" class="btn btn-outline-danger btn-sm" title="Withdraw">
                                                    <i class="fas fa-arrow-up"></i>
                                                </a>
                                                <a href="{{ route('user.swap.index') }}" class="btn btn-outline-primary btn-sm" title="Swap">
                                                    <i class="fas fa-exchange-alt"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="5" class="text-center py-4">
                                            <i class="fas fa-wallet text-muted" style="font-size: 2rem;"></i>
                                            <p class="text-muted mt-2">No balances found</p>
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    @if ($balances->count() > 0)
                        <div class="alert alert-info mt-3 mb-0" role="alert">
                            <i class="fas fa-info-circle me-1"></i>
                            <strong>Note:</strong> Prices are updated in real-time from CoinGecko. Your total portfolio value is calculated based on current market rates.
                        </div>
                    @endif

                </x-dashboard.card>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="row mt-3">
            <div class="col-md-4 mb-3">
                <x-dashboard.card>
                    <div class="text-center py-2">
                        <i class="fas fa-arrow-down text-success mb-2" style="font-size: 2rem;"></i>
                        <h6 class="mb-2">Deposit</h6>
                        <p class="text-muted small mb-3">Add funds to your wallet</p>
                        <a href="{{ route('user.deposit.index') }}" class="btn btn-success btn-sm">
                            <i class="fas fa-plus me-1"></i> Deposit Now
                        </a>
                    </div>
                </x-dashboard.card>
            </div>

            <div class="col-md-4 mb-3">
                <x-dashboard.card>
                    <div class="text-center py-2">
                        <i class="fas fa-arrow-up text-danger mb-2" style="font-size: 2rem;"></i>
                        <h6 class="mb-2">Withdraw</h6>
                        <p class="text-muted small mb-3">Send funds from your wallet</p>
                        <a href="{{ route('user.withdraw.index') }}" class="btn btn-danger btn-sm">
                            <i class="fas fa-minus me-1"></i> Withdraw Now
                        </a>
                    </div>
                </x-dashboard.card>
            </div>

            <div class="col-md-4 mb-3">
                <x-dashboard.card>
                    <div class="text-center py-2">
                        <i class="fas fa-exchange-alt text-primary mb-2" style="font-size: 2rem;"></i>
                        <h6 class="mb-2">Swap</h6>
                        <p class="text-muted small mb-3">Exchange between cryptocurrencies</p>
                        <a href="{{ route('user.swap.index') }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-exchange-alt me-1"></i> Swap Now
                        </a>
                    </div>
                </x-dashboard.card>
            </div>
        </div>

    </div>
@endsection
