@extends('dashboard.user.layouts.app')
@section('content')
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@flaticon/flaticon-uicons/css/all/all.css">

    <style>
        .live-chat-card {
            /* background: #ffffff; */
            border-radius: 14px;
            padding: 28px;
            /* border: 1px solid #eef1f6; */
            max-width: 650px;
        }

        .live-chat-title {
            font-size: 1.75rem;
            /* BIG title */
            font-weight: 700;
            margin-bottom: 12px;
        }

        .live-chat-desc {
            font-size: 1.05rem;
            line-height: 1.7;
            color: #4b5563;
            margin-bottom: 8px;
        }

        .live-chat-sub {
            font-size: 0.95rem;
            color: #6b7280;
        }

        .chat-loader,
        .chat-success {
            font-size: 1rem;
            font-weight: 500;
        }

        .spinning-icon {
            font-size: 1.4rem;
            animation: spin 1.2s linear infinite;
        }

        @keyframes spin {
            from {
                transform: rotate(0deg);
            }

            to {
                transform: rotate(360deg);
            }
        }

        .chat-success {
            background: #f0fdf4;
            border: 1px solid #dcfce7;
            padding: 14px 16px;
            border-radius: 10px;
            animation: fadeIn 0.5s ease-in-out;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(6px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
    </style>
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-10">
                            <div class="live-chat-card">

                                <h2 class="live-chat-title">
                                    Live Chat Support
                                </h2>

                                <p class="live-chat-desc">
                                    Need assistance? Start a live chat with our dedicated support team.
                                    We’re here to help you resolve any issue or answer your questions
                                    in real time.
                                </p>

                                <p class="live-chat-sub">
                                    Please hang on for a moment while the chat widget loads.
                                </p>

                                <!-- Animated Chat Loader -->
                                <div id="chat-loader" class="chat-loader d-flex align-items-center mt-4">
                                    <i class="fi fi-rr-comments spinning-icon me-2"></i>
                                    <span>Connecting to live support…</span>
                                </div>

                                <!-- Success Message -->
                                <div id="chat-success" class="chat-success mt-4 d-none">
                                    <i class="fi fi-rr-check-circle text-success me-2"></i>
                                    Live chat is ready. Check the bottom-right corner of your screen.
                                </div>

                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const loader = document.getElementById('chat-loader');
            const success = document.getElementById('chat-success');

            // Simulate chat widget loading
            setTimeout(() => {
                loader.classList.add('d-none'); // hide loader
                success.classList.remove('d-none'); // show success
            }, 2500); // 2.5 seconds
        });
    </script>
@endsection
