@extends('dashboard.user.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <div class="col-xl-4 col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center gap-2">
                            @if ($user->image)
                                <a href="{{ asset($user->image) }}" target="_blank"><img src="{{ asset($user->image) }}"
                                        class="avatar-xl rounded-circle border border-light border-2"></a>
                            @else
                                <img src="{{ asset('assets/images/avatar.png') }}"
                                    class="avatar-xl rounded-circle border border-light border-2">
                            @endif
                            <div>
                                <h4 class="text-dark fw-medium">{{ $user->name }}</h4>
                                <p class="mb-0 text-muted">IP:{{ $user->last_login_ip }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer border-top border-dashed">
                        <div class="list-group list-group-flush">

                            <!-- Profile Image -->
                            <a href="{{ route('user.profile.image') }}"
                                class="list-group-item list-group-item-action d-flex align-items-center">
                                <i class="ti ti-photo text-primary me-2 fs-5"></i>
                                <div>
                                    <div class="fw-bold">Upload Profile Image</div>
                                    <small class="text-muted">Upload your account photo for better personalization</small>
                                </div>
                            </a>

                            <!-- Password Settings -->
                            <a href="{{ route('user.profile.password') }}"
                                class="list-group-item list-group-item-action d-flex align-items-center">
                                <i class="ti ti-lock text-warning me-2 fs-5"></i>
                                <div>
                                    <div class="fw-bold">Password Settings</div>
                                    <small class="text-muted">Manage your login password and keep your account
                                        secure</small>
                                </div>
                            </a>

                            <!-- Two-Factor Authentication -->
                            <a href="{{ route('user.profile.2fa') }}"
                                class="list-group-item list-group-item-action d-flex align-items-center">
                                <i class="ti ti-shield-lock text-success me-2 fs-5"></i>
                                <div class="d-flex flex-column">
                                    <div class="fw-bold">Two-Factor Authentication</div>
                                    <small class="text-muted">Add an extra layer of security to your account</small>
                                </div>
                            </a>

                            <!-- KYC Verification -->
                            <a href="{{ route('user.profile.kyc') }}"
                                class="list-group-item list-group-item-action d-flex align-items-center">
                                <i class="ti ti-id text-info me-2 fs-5"></i>
                                <div>
                                    <div class="fw-bold">KYC Verification</div>
                                    <small class="text-muted">Verify your identity to unlock full account access</small>
                                </div>
                            </a>

                            <!-- Notification -->
                            <a href="{{ route('user.notification.index') }}"
                                class="list-group-item list-group-item-action d-flex align-items-center">
                                <i class="ti ti-bell text-primary me-2 fs-5"></i>
                                <div>
                                    <div class="fw-bold">Notification</div>
                                    <small class="text-muted">View your recent notifications and announcements</small>
                                </div>
                            </a>

                            <!-- Support Center -->
                            <a href="{{ route('user.support.index') }}"
                                class="list-group-item list-group-item-action d-flex align-items-center">
                                <i class="ti ti-help-circle text-primary me-2 fs-5"></i>
                                <div>
                                    <div class="fw-bold">Support Center</div>
                                    <small class="text-muted">Get help from our dedicated support team</small>
                                </div>
                            </a>

                        </div>
                    </div>

                </div>
            </div>
            <div class="col-xl-8 col-lg-12">
                <div class="card">
                    <div class="card-header border-bottom">
                        <h4 class="header-title">Account Information</h4>
                    </div>
                    <div class="card-body">
                        <div class="row justify-content-between align-items-center">
                            <div class="col-lg-3 col-6 border-end border-dashed">
                                <p class="text-muted mb-1">Full Name</p>
                                <p class="fs-15 fw-medium mb-3">
                                    {{ $user->name }}
                                </p>
                                <p class="text-muted mb-1">Last Login</p>
                                <p class="fs-15 fw-medium mb-0">{{ formatDateTime($user->last_login_at) }}</p>
                            </div>

                            <div class="col-lg-3 col-6 border-end border-dashed">
                                <p class="text-muted mb-1">Email</p>
                                <p class="fs-15 fw-medium mb-3">{{ $user->email }}</p>
                                <p class="text-muted mb-1">Phone</p>
                                <p class="fs-15 fw-medium mb-0">{{ $user->phone ?? 'Not provided' }}</p>
                            </div>

                            <div class="col-lg-3 col-6">
                                <p class="text-muted mb-1">Country</p>
                                <p class="fs-15 fw-medium mb-3">{{ $user->country ?? '—' }}</p>
                                <p class="text-muted mb-1">State, City, Zip</p>
                                <p class="fs-15 fw-medium mb-0">
                                    {{ ($user->state ?? '—') . ', ' . ($user->city ?? '—') . ', ' . ($user->zip_code ?? '—') }}
                                </p>
                            </div>
                            <div class="col-lg-3 col-6">
                                <p class="text-muted mb-1">Address</p>
                                <p class="fs-15 fw-medium mb-3">{{ $user->address ?? '—' }}</p>
                                <p class="text-muted mb-1">Register Date</p>
                                <p class="fs-15 fw-medium mb-0">{{ formatDateTime($user->created_at) }}</p>
                            </div>
                        </div>

                        <hr class="my-3">
                        <h4 class="mb-0 fs-15 fw-semibold">Account Details :</h4>
                        <div class="row mt-2 g-2">
                            <div class="col-lg-3 col-6">
                                <h3 class="fw-medium">
                                    {{ currency($user->currency) }}{{ formatAmount($user->balance) }}
                                </h3>
                                <p class="mb-0 text-muted">Balance</p>
                            </div>
                            <div class="col-lg-3 col-6">
                                <h3 class="fw-medium">
                                    {{ currency($user->currency) }}{{ formatAmount($user->demo_balance) }}
                                </h3>
                                <p class="mb-0 text-muted">Demo Balance</p>
                            </div>
                            <div class="col-lg-3 col-6">
                                <h3 class="fw-medium">{{ currency($user->currency, 'code') }}</h3>
                                <p class="mb-0 text-muted">Account Currency</p>
                            </div>
                        </div>

                        <hr class="my-3">
                        <h4 class="mb-0 fs-15 fw-semibold">Account Preferences :</h4>
                        <div class="row mt-2 g-2">
                            <div class="col-lg-3 col-6">
                                <h3 class="fw-medium">{{ $user->account_type->label() }}</h3>
                                <p class="mb-0 text-muted">Account Type</p>
                            </div>
                            <div class="col-lg-3 col-6">
                                <h3 class="fw-medium {{ $user->two_factor_enabled->textColor() }}">
                                    {{ $user->two_factor_enabled->label() }}
                                </h3>
                                <p class="mb-0 text-muted">2FA Security</p>
                            </div>
                            <div class="col-lg-3 col-6">
                                <h3 class="fw-medium {{ $user->status->textColor() }}">
                                    {{ $user->status->label() }}
                                </h3>
                                <p class="mb-0 text-muted">Account Status</p>
                            </div>
                            <div class="col-lg-3 col-6">
                                <h3 class="fw-medium {{ $user->account_mode->textColor() }}">
                                    {{ $user->account_mode->label() }}
                                </h3>
                                <p class="mb-0 text-muted">Account Mode</p>
                            </div>
                        </div>

                        <hr class="my-3">
                        <h4 class="mb-0 fs-15 fw-semibold">KYC Information :</h4>
                        <div class="row mt-2 g-2">
                            <div class="col-lg-3 col-6">
                                <h3 class="fw-medium {{ $user->kyc_status->textColor() }}">
                                    {{ $user->kyc_status->label() }}</h3>
                                <p class="mb-0 text-muted">KYC Status</p>
                            </div>
                            <div class="col-lg-3 col-6">
                                <h3 class="fw-medium">{{ $user->id_type ? $user->id_type->label() : 'Not Uploaded' }}</h3>
                                <p class="mb-0 text-muted">ID Type</p>
                            </div>
                            <div class="col-lg-3 col-6">
                                @if (@$user->id_front)
                                    <a href="{{ asset($user->id_front) }}" target="_blank"
                                        class="fw-medium text-primary">View Front</a>
                                @else
                                    <span class="text-muted">Not Uploaded</span>
                                @endif
                                <p class="mb-0 text-muted">ID Front</p>
                            </div>
                            <div class="col-lg-3 col-6">
                                @if (@$user->id_back)
                                    <a href="{{ asset($user->id_back) }}" target="_blank"
                                        class="fw-medium text-primary">View Back</a>
                                @else
                                    <span class="text-muted">Not Uploaded</span>
                                @endif
                                <p class="mb-0 text-muted">ID Back</p>
                            </div>
                        </div>
                        {{-- <hr class="my-3">
                        <h4 class="mb-0 fs-15 fw-semibold">API Keys :</h4>
                        <div class="row mt-2 g-2">
                            <div class="col-lg-3 col-6">
                                <h3 class="fw-medium">
                                    {{ $user->api_key }}
                                </h3>
                                <p class="mb-0 text-muted">API Key</p>
                            </div>
                            <div class="col-lg-3 col-6">
                                <h3 class="fw-medium">
                                    {{ $user->secret_key }}
                                </h3>
                                <p class="mb-0 text-muted">Secret Key</p>
                            </div>
                        </div> --}}
                        <hr class="my-3">

                        <h4 class="mb-2 fs-15 fw-semibold">API Keys</h4>
                        <p class="text-muted fs-13 mb-3">
                            Keep these keys secure. Do not share them publicly.
                        </p>

                        <div class="row g-3">

                            <!-- API Key -->
                            <div class="col-lg-6">
                                <div class="card border">
                                    <div class="card-body p-3">
                                        <label class="text-muted fs-12 mb-1">API Key</label>

                                        <div class="input-group">
                                            <input type="text" class="form-control fw-medium" id="apiKey"
                                                value="{{ trim($user->api_key) }}" readonly>
                                            <button class="btn btn-outline-secondary" type="button"
                                                onclick="copyToClipboard('apiKey', this)">
                                                <i class="ti ti-copy"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Secret Key -->
                            <div class="col-lg-6">
                                <div class="card border">
                                    <div class="card-body p-3">
                                        <label class="text-muted fs-12 mb-1">Secret Key</label>

                                        <div class="input-group">
                                            <input type="password" class="form-control fw-medium" id="secretKey"
                                                value="{{ trim($user->secret_key) }}" readonly>
                                            <button class="btn btn-outline-secondary" type="button"
                                                onclick="toggleSecret(this, 'secretKey')">
                                                <i class="ti ti-eye"></i>
                                            </button>
                                            <button class="btn btn-outline-secondary" type="button"
                                                onclick="copyToClipboard('secretKey', this)">
                                                <i class="ti ti-copy"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>

                    </div>
                </div>

            </div>
        </div>

    </div>
    <script>
        function copyToClipboard(inputId, btn) {
            const input = document.getElementById(inputId);
            input.select();
            input.setSelectionRange(0, 99999);

            navigator.clipboard.writeText(input.value).then(() => {
                const original = btn.innerHTML;
                btn.innerHTML = '<i class="ti ti-check"></i>';
                btn.classList.add('btn-success');
                btn.classList.remove('btn-outline-secondary');

                setTimeout(() => {
                    btn.innerHTML = original;
                    btn.classList.remove('btn-success');
                    btn.classList.add('btn-outline-secondary');
                }, 1500);
            });
        }

        function toggleSecret(btn, inputId) {
            const input = document.getElementById(inputId);
            const icon = btn.querySelector('i');

            if (input.type === 'password') {
                input.type = 'text';
                icon.classList.replace('ti-eye', 'ti-eye-off');
            } else {
                input.type = 'password';
                icon.classList.replace('ti-eye-off', 'ti-eye');
            }
        }
    </script>
@endsection
