@extends('dashboard.user.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <div class="col-lg-12">
                <x-dashboard.card title="Upload your profile image">
                    <form action="{{ route('user.profile.image') }}" method="post" enctype="multipart/form-data">
                        @csrf
                        @method('PATCH')

                        <div class="row">
                            <div class="col-lg-12">
                                <div class="mb-3">
                                    <label class="form-label">Profile Image</label>
                                    <input type="file" class="form-control @error('image') is-invalid @enderror"
                                        accept="image/*" name="image">

                                    <x-dashboard.input-error name="image" />
                                </div>
                            </div>

                            @if ($user->image)
                                <div class="col-12 mb-3">
                                    <img src="{{ asset($user->image) }}" class="img-thumbnail" width="250">
                                </div>
                            @endif
                        </div>

                        <x-dashboard.submit-and-back-button href="{{ route('user.profile.index') }}" back="Back to Profile"
                            submit="Upload" class="btn btn-primary" />

                    </form>
                </x-dashboard.card>
            </div>
            <!-- end col -->
        </div>
        <!-- end row -->

    </div>
@endsection
