@extends('dashboard.user.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <div class="col-12">

                <x-dashboard.card title="{{ $title }}">

                    <form action="{{ route('user.premium.signal.subscription.store') }}" method="post"
                        enctype="multipart/form-data">
                        @csrf

                        <div class="col-md-12 mb-3">
                            <label class="form-label">Select Our Premium Plan</label>
                            <select name="plan_id" class="form-select @error('plan_id') is-invalid @enderror">
                                <option value="">Select</option>
                                @foreach ($plans as $plan)
                                    <option value="{{ $plan->id }}" {{ old('plan_id') == $plan->id ? 'selected' : '' }}>
                                        {{ $plan->name . ' ' . '-' . ' ' . currency($user->currency) . formatAmount($plan->minimum, 0) }}
                                    </option>
                                @endforeach
                            </select>
                            <small class="form-text text-muted">Lifetime subscription currently on promotional
                                offer.</small>

                            @error('plan_id')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="col-md-12 mb-3">
                            <label class="form-label">Payment (Deposit exact amount in BTC or USDT equivalent)</label>
                            <ul class="list-unstyled">
                                @foreach ($wallets as $wallet)
                                    <li><strong>{{ $wallet->name }}:</strong> {{ $wallet->address }}</li>
                                @endforeach
                            </ul>
                        </div>

                        <x-dashboard.form-input name="telegram_username" label="Telegram Username" class="col-md-12 mb-3"
                            value="{{ old('telegram_username') }}" required />

                        <x-dashboard.form-input name="transaction_id" label="Transaction ID (TXID)" class="col-md-12 mb-3"
                            value="{{ old('transaction_id') }}" required />

                        <x-dashboard.form-input name="proof" label="Payment Proof" class="col-md-12 mb-3"
                            type="file" />

                        <x-dashboard.form-button />

                    </form>

                </x-dashboard.card>

            </div>
        </div>

    </div>
@endsection
