<form action="{{ route('user.trade.open') }}" method="POST">
    @csrf

    <!-- Market Selection -->
    <div class="mb-3">
        <label for="market_id" class="form-label">Market</label>
        <select class="form-select" id="market_id" name="market_id" required>
            <option value="">Select Market</option>
            @foreach ($markets as $market)
                <option value="{{ $market->id }}">{{ $market->asset }}</option>
            @endforeach
        </select>
        @error('market_id')
            <small class="text-danger">{{ $message }}</small>
        @enderror
    </div>

    <!-- Trade Type -->
    <div class="mb-3">
        <label class="form-label">Trade Type</label>
        <select class="form-select" name="type" required>
            <option value="">Select Type</option>
            <option value="buy">Buy</option>
            <option value="sell">Sell</option>
        </select>
        @error('type')
            <small class="text-danger">{{ $message }}</small>
        @enderror
    </div>

    <!-- Mode Selection -->
    <div class="mb-3">
        <label class="form-label">Mode</label>
        <select class="form-select" name="mode" required>
            <option value="demo">Demo Account</option>
            <option value="live">Live Account</option>
        </select>
        @error('mode')
            <small class="text-danger">{{ $message }}</small>
        @enderror
    </div>

    <!-- Trade Amount -->
    <div class="mb-3">
        <label for="amount" class="form-label">Amount</label>
        <input type="number" class="form-control" id="amount" name="amount" placeholder="Enter trade amount"
            step="0.01" min="10" required>
        @error('amount')
            <small class="text-danger">{{ $message }}</small>
        @enderror
    </div>

    <!-- Submit Button -->
    <div class="d-grid">
        <button type="submit" class="btn btn-success">Open Trade</button>
    </div>
</form>
