@extends('dashboard.user.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <div class="col-lg-8">
                <div class="card shadow-sm">
                    <div class="card-body">

                        <!-- Status Badge -->
                        <div class="mb-4">
                            <div class="d-flex justify-content-between align-items-start">
                                <h5 class="fw-semibold">Request Details</h5>
                                <span class="{{ $request->status->badge() }}">
                                    {{ $request->status->label() }}
                                </span>
                            </div>
                            <hr>
                        </div>

                        <!-- Request Information -->
                        <div class="row g-4">
                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Amount</label>
                                <p class="text-muted">
                                    {{ currency($user->currency) }}{{ formatAmount($request->amount) }}
                                </p>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Payment Method</label>
                                <p class="text-muted">
                                    {{ $request->wallet?->name ?? 'N/A' }}
                                </p>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Requested Date</label>
                                <p class="text-muted">
                                    {{ $request->created_at->format('M d, Y H:i A') }}
                                </p>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Status</label>
                                <p class="text-muted">
                                    {{ $request->status->label() }}
                                </p>
                            </div>

                            @if ($request->reviewed_at)
                                <div class="col-md-6">
                                    <label class="form-label fw-semibold">Reviewed Date</label>
                                    <p class="text-muted">
                                        {{ $request->reviewed_at->format('M d, Y H:i A') }}
                                    </p>
                                </div>
                            @endif

                            @if ($request->admin_note)
                                <div class="col-12">
                                    <label class="form-label fw-semibold">Admin Note</label>
                                    <div class="alert alert-secondary" role="alert">
                                        {{ $request->admin_note }}
                                    </div>
                                </div>
                            @endif

                            @if ($request->proof)
                                <div class="col-12">
                                    <label class="form-label fw-semibold">Payment Proof</label>
                                    <div class="mt-2">
                                        <img src="{{ asset($request->proof) }}" alt="Payment Proof"
                                            class="img-fluid rounded border" style="max-height: 400px;">
                                    </div>
                                </div>
                            @endif
                        </div>

                        <hr class="my-4">

                        <!-- Status Timeline -->
                        <div class="mb-4">
                            <h6 class="fw-semibold mb-3">Status Timeline</h6>
                            <div class="timeline">
                                <div class="timeline-item">
                                    <div class="timeline-marker {{ $request->status !== 'pending' ? 'bg-success' : 'bg-warning' }}"></div>
                                    <div class="timeline-content">
                                        <h6 class="fw-semibold">Requested</h6>
                                        <p class="text-muted small">{{ $request->created_at->format('M d, Y H:i A') }}</p>
                                    </div>
                                </div>

                                @if ($request->reviewed_at)
                                    <div class="timeline-item">
                                        <div class="timeline-marker {{ $request->isApproved() ? 'bg-success' : 'bg-danger' }}"></div>
                                        <div class="timeline-content">
                                            <h6 class="fw-semibold">
                                                {{ $request->isApproved() ? 'Approved' : 'Declined' }}
                                            </h6>
                                            <p class="text-muted small">{{ $request->reviewed_at->format('M d, Y H:i A') }}</p>
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>

                        <!-- Action Buttons -->
                        <div class="d-flex justify-content-between">
                            <a href="{{ route('user.isolated_margin.index') }}" class="btn btn-light">
                                <i class="ti ti-arrow-back"></i> Back
                            </a>

                            @if ($request->isPending())
                                <button class="btn btn-warning" data-bs-toggle="modal" data-bs-target="#editModal">
                                    <i class="ti ti-edit"></i> Edit Request
                                </button>
                            @endif
                        </div>

                    </div>
                </div>
            </div>

            <!-- Info Sidebar -->
            <div class="col-lg-4">
                <div class="card shadow-sm border-0">
                    <div class="card-body">
                        <h6 class="fw-semibold mb-3">
                            <i class="ti ti-info-circle me-2"></i>Information
                        </h6>
                        <div class="alert alert-info" role="alert">
                            <small>
                                Your isolated margin upgrade request has been submitted for review.
                                The admin team will review your submission and notify you of the status.
                            </small>
                        </div>

                        @if ($request->isApproved())
                            <div class="alert alert-success" role="alert">
                                <small>
                                    <strong>Approved!</strong> Your isolated margin has been successfully upgraded.
                                </small>
                            </div>
                        @elseif ($request->isDeclined())
                            <div class="alert alert-danger" role="alert">
                                <small>
                                    <strong>Declined.</strong> Please contact support for more information.
                                </small>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>

    </div>

    <style>
        .timeline {
            position: relative;
            padding-left: 30px;
        }

        .timeline-item {
            position: relative;
            padding-bottom: 20px;
        }

        .timeline-item:not(:last-child)::before {
            content: '';
            position: absolute;
            left: -17px;
            top: 30px;
            width: 2px;
            height: 30px;
            background-color: #e9ecef;
        }

        .timeline-marker {
            position: absolute;
            left: -24px;
            top: 0;
            width: 16px;
            height: 16px;
            border-radius: 50%;
            border: 3px solid #fff;
            box-shadow: 0 0 0 2px #e9ecef;
        }

        .timeline-content {
            padding-left: 10px;
        }
    </style>
@endsection
