@extends('dashboard.user.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <!-- Information Card -->
            <div class="col-12 mb-4">
                <div class="card shadow-sm border-0">
                    <div class="card-body">
                        <div class="d-flex align-items-start mb-3">
                            <div class="me-3">
                                <i class="ti ti-shield-lock fs-3 text-primary"></i>
                            </div>
                            <div class="flex-grow-1">
                                <h5 class="fw-semibold mb-2">What is Isolated Margin?</h5>
                                <p class="text-muted mb-0">
                                   Isolated margin is a risk-management mechanism in leveraged trading that confines potential losses to the specific amount of margin allocated to an individual position. In this mode, each trade operates independently — the broker assigns a fixed margin to a position, and if the market moves unfavorably, only that amount is at risk. The remaining account balance remains protected, this mechanism is put in place to protect your profit. This approach offers greater control over exposure, making it particularly suitable for investors seeking disciplined risk containment in volatile markets such as cryptocurrency and forex. By isolating capital per trade, isolated margin trading prevents a single losing position from depleting an entire portfolio, ensuring structured and strategic capital preservation.
                                </p>
                            </div>
                        </div>

                        <hr class="my-3">

                        <div class="alert alert-info mb-0">
                            <strong>Key Benefits:</strong>
                            <ul class="mb-0 mt-2">
                                <li>Greater control over exposure and risk</li>
                                <li>Suitable for investors seeking disciplined risk containment</li>
                                <li>Particularly effective in volatile markets such as cryptocurrency and forex</li>
                                <li>Prevents a single losing position from depleting an entire portfolio</li>
                                <li>Ensures structured and strategic capital preservation</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Requests List -->
            <div class="col-12">
                <x-dashboard.card title="Isolated Margin Requests" :button="[
                    'route' => route('user.isolated_margin.method'),
                    'text' => 'Upgrade Isolated Margin',
                    'icon' => 'fa fa-plus me-1',
                ]">

                    <div class="table-responsive d-none d-md-block">
                        <table id="myTable" class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Amount</th>
                                    <th>Payment Method</th>
                                    <th>Status</th>
                                    <th>Requested Date</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($requests as $request)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ currency($user->currency) }}{{ formatAmount($request->amount) }}</td>
                                        <td>{{ $request->wallet?->name ?? 'N/A' }}</td>
                                        <td>
                                            <span class="{{ $request->status->badge() }}">
                                                {{ $request->status->label() }}
                                            </span>
                                        </td>
                                        <td>{{ $request->created_at->format('M d, Y H:i') }}</td>
                                        <td>
                                            <a href="{{ route('user.isolated_margin.show', $request->uuid) }}"
                                                class="btn btn-info btn-sm"> <i class="fa fa-file-text me-1"></i> View</a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    <div class="d-block d-md-none">
                        @foreach ($requests as $request)
                            <div class="card mb-3 shadow-sm">
                                <div class="card-body">
                                    <h5 class="card-title">
                                        <strong>Amount:</strong>
                                        {{ currency($user->currency) }}{{ formatAmount($request->amount) }}
                                    </h5>

                                    <p class="mb-1"><strong>Payment Method:</strong>
                                        {{ $request->wallet?->name ?? 'N/A' }}
                                    </p>
                                    <p class="mb-1"><strong>Requested:</strong>
                                        {{ $request->created_at->format('M d, Y H:i') }}
                                    </p>
                                    <p class="mb-2"><strong>Status:</strong>
                                        <span class="{{ $request->status->badge() }}">
                                            {{ $request->status->label() }}
                                        </span>
                                    </p>

                                    <div class="d-flex gap-2">
                                        <a href="{{ route('user.isolated_margin.show', $request->uuid) }}"
                                            class="btn btn-info btn-sm"> <i class="fa fa-file-text me-1"></i>
                                            View</a>
                                    </div>
                                </div>
                            </div>
                        @endforeach

                        @if ($requests->isEmpty())
                            <div class="text-center py-5">
                                <i class="ti ti-package-off fs-1 text-muted"></i>
                                <p class="text-muted mt-3">No isolated margin requests found</p>
                            </div>
                        @endif
                    </div>

                </x-dashboard.card>

            </div>
        </div>

    </div>
@endsection
