@extends('dashboard.user.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <div class="card shadow-sm border-0">
                    <div class="card-body p-4">

                        <!-- Header Section -->
                        <div class="d-flex justify-content-between align-items-start mb-4">
                            <div>
                                <h5 class="mb-1 fw-semibold">Transaction Details</h5>
                                <small class="text-muted">
                                    {{ formatDateTime($transaction->transaction_at) }}
                                </small>
                            </div>

                            <div class="text-end">
                                @if ($transaction->isDirectionCredit())
                                    <h4 class="fw-bold text-success mb-1">
                                        +{{ currency($user->currency) }}{{ formatAmount($transaction->amount) }}
                                    </h4>
                                @else
                                    <h4 class="fw-bold text-danger mb-1">
                                        -{{ currency($user->currency) }}{{ formatAmount($transaction->amount) }}
                                    </h4>
                                @endif

                                <span class="badge {{ $transaction->status->badge() }}">
                                    {{ $transaction->status->label() }}
                                </span>
                            </div>
                        </div>

                        <hr>

                        <!-- Core Information -->
                        <div class="row gy-3">
                            <div class="col-md-6">
                                <small class="text-muted d-block">Transaction ID</small>
                                <span class="fw-medium">{{ $transaction->uuid }}</span>
                            </div>

                            <div class="col-md-6">
                                <small class="text-muted d-block">Reference</small>
                                <span class="fw-medium">{{ $transaction->reference_id }}</span>
                            </div>

                            <div class="col-md-6">
                                <small class="text-muted d-block">Transaction Type</small>
                                <span class="fw-medium">{{ $transaction->type->label() }}</span>
                            </div>

                            <div class="col-md-6">
                                <small class="text-muted d-block">Description</small>
                                <span class="fw-medium">
                                    {{ $transaction->description ?? 'No description provided' }}
                                </span>
                            </div>

                            @if ($transaction->note)
                                <div class="col-12">
                                    <div class="bg-light rounded p-3">
                                        <small class="text-muted d-block mb-1">Additional Note</small>
                                        <span>{{ $transaction->note }}</span>
                                    </div>
                                </div>
                            @endif
                        </div>

                    </div>
                </div>

            </div>
        </div>

    </div>
@endsection
