@extends('dashboard.user.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <!-- Market Ticker -->
            <div class="col-12 mt-3 mb-3">
                <div class="card border-0 shadow-sm">
                    <div class="card-body p-2">
                        <div class="tradingview-widget-container">
                            <div class="tradingview-widget-container__widget"></div>
                            <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-ticker-tape.js" async>
                                {
                                    "symbols": [{
                                            "proName": "FOREXCOM:SPXUSD",
                                            "title": "S&P 500"
                                        },
                                        {
                                            "proName": "FOREXCOM:NSXUSD",
                                            "title": "US 100"
                                        },
                                        {
                                            "proName": "FX_IDC:EURUSD",
                                            "title": "EUR/USD"
                                        },
                                        {
                                            "proName": "BITSTAMP:BTCUSD",
                                            "title": "Bitcoin"
                                        },
                                        {
                                            "proName": "BITSTAMP:ETHUSD",
                                            "title": "Ethereum"
                                        }
                                    ],
                                    "showSymbolLogo": true,
                                    "colorTheme": "dark",
                                    "displayMode": "adaptive",
                                    "locale": "en"
                                }
                            </script>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Deposit Card -->
            <div class="col-12 grid-margin stretch-card">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <div class="row">

                            <!-- Payment Details -->
                            <div class="col-md-6 mb-4">

                                <div class="text-center mb-3">
                                    <img src="{{ asset($wallet->logo_path) }}" width="48" alt="{{ $wallet->name }}">
                                </div>

                                <div class="text-center mb-3">
                                    @if ($wallet->qr_code_path)
                                        <img class="img-fluid rounded border" src="{{ asset($wallet->qr_code_path) }}"
                                            alt="QR Code">
                                    @else
                                        <img src="https://api.qrserver.com/v1/create-qr-code/?size=200x200&data={{ $wallet->address }}"
                                            alt="QR Code" class="img-fluid rounded border">
                                    @endif
                                </div>

                                <!-- Wallet Address -->
                                <label class="form-label fw-semibold">Wallet Address</label>
                                <div class="input-group mb-3">
                                    <input type="text" value="{{ $wallet->address }}" class="form-control" id="copyText"
                                        readonly>
                                    <button class="btn btn-outline-primary" type="button" id="copyButton">
                                        <i class="ti ti-copy"></i>
                                    </button>
                                </div>

                                <a href="{{ route('user.deposit.payment.proof', $wallet->uuid) }}">
                                    <button class="btn btn-success w-100">
                                        I Have Made This Payment
                                    </button>
                                </a>

                            </div>

                            <!-- Instructions -->
                            <div class="col-md-6">

                                <h5 class="fw-semibold mb-3">How to Make a Deposit</h5>
                                <p class="text-muted">
                                    Copy the company wallet address and paste it into the recipient field of your
                                    {{ $wallet->name }} wallet application.
                                    You may also scan the QR code if you are using a mobile wallet.
                                </p>

                                <ul class="text-muted">
                                    <li>Ensure the correct network is selected</li>
                                    <li>Send the exact or higher amount required</li>
                                    <li>Transaction confirmation may take a few minutes</li>
                                </ul>

                                <hr>

                                <h5 class="fw-semibold mb-3">How to Buy {{ $wallet->name }}</h5>
                                <ol class="text-muted">
                                    <li>Create a {{ $wallet->name }} wallet</li>
                                    <li>Select a trusted exchange</li>
                                    <li>Complete identity verification</li>
                                    <li>Add a payment method</li>
                                    <li>Purchase and transfer to your wallet</li>
                                </ol>

                                <p class="text-muted">
                                    Your wallet address functions like a bank account number.
                                    Always verify addresses before sending funds.
                                </p>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <script>
        document.getElementById("copyButton").addEventListener("click", function() {
            const copyText = document.getElementById("copyText");
            navigator.clipboard.writeText(copyText.value);

            this.innerHTML = '<i class="ti ti-check"></i>';
            setTimeout(() => {
                this.innerHTML = '<i class="ti ti-copy"></i>';
            }, 1500);
        });
    </script>
@endsection
