@extends('dashboard.user.layouts.app')
@section('content')
    <style>
        .payment-card {
            border: 1px solid #e9ecef;
            border-radius: 12px;
            transition: all 0.25s ease;
        }

        .payment-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
        }

        .payment-logo {
            width: 56px;
            height: 56px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .payment-logo img {
            max-width: 100%;
            max-height: 100%;
            object-fit: contain;
        }

        .wallet-address {
            font-size: 0.85rem;
            color: #6c757d;
            word-break: break-all;
        }
    </style>

    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <div class="col-12 mt-3">

                <!-- Section Header -->
                <div class="mb-4">
                    <h2 class="fw-semibold mb-2">Select Payment Method</h2>
                    <p class="text-muted mb-3">
                        Choose a preferred payment option below. All transactions are processed securely and
                        efficiently.
                    </p>
                    <hr>
                </div>

                <!-- Crypto Payments -->
                <div class="mb-4">
                    <h4 class="fw-semibold mb-1">Cryptocurrency Payments</h4>
                    <p class="text-muted">
                        Fund your account using supported blockchain networks.
                    </p>
                </div>

                <div class="row g-4">

                    <!-- Payment Card -->
                    @forelse ($wallets as $wallet)
                        <div class="col-lg-4 col-md-6">
                            <a href="{{ route('user.deposit.payment', $wallet->uuid) }}" class="text-decoration-none">
                                <div class="card payment-card h-100">
                                    <div class="card-body d-flex align-items-center">
                                        <div class="payment-logo me-3">
                                            <img src="{{ asset($wallet->logo_path) }}" alt="{{ $wallet->name }}"
                                                width="48">
                                        </div>
                                        <div>
                                            <h6 class="mb-0 fw-semibold">{{ $wallet->name }}</h6>
                                            <small class="text-muted">{{ $wallet->network }}</small>
                                            <p class="wallet-address mt-2 mb-0">
                                                {{ $wallet->address }}
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </a>
                        </div>
                    @empty
                        <div class="col-12">
                            <div class="card border-0 bg-light">
                                <div class="card-body text-center py-5">
                                    <div class="mb-3">
                                        <i class="ti ti-wallet-off fs-1 text-muted"></i>
                                    </div>
                                    <h5 class="fw-semibold mb-2">No Payment Methods Available</h5>
                                    <p class="text-muted mb-0">
                                        Cryptocurrency payment options are currently unavailable.
                                        Please check back later or contact support for assistance.
                                    </p>
                                </div>
                            </div>
                        </div>
                    @endforelse

                </div>

            </div>

        </div>

    </div>
@endsection
