@extends('dashboard.user.layouts.app')

@section('content')
    <div class="page-container">
        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>
            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <div class="col-lg-6 offset-lg-3">
                <div class="card shadow-sm">
                    <div class="card-body">
                        @if ($user->wallet_address)
                            <div class="alert alert-soft-success d-flex align-items-center">
                                <i class="ti ti-wallet fs-2 me-2"></i>
                                <div>
                                    <h6 class="mb-1">Connected Wallet</h6>
                                    <p class="mb-0 text-break">{{ $user->wallet_address }}</p>
                                </div>
                            </div>
                        @else
                            <div class="alert alert-soft-warning">
                                <i class="ti ti-alert-circle me-1"></i>
                                You haven't connected a wallet yet. Please connect a wallet to withdraw your profits.
                                <a href="{{ route('user.copy.trade.wallet.connect') }}" class="alert-link">Connect
                                    Wallet</a>
                            </div>
                        @endif

                        <form action="{{ route('user.copy.trade.withdraw.store', $trader->uuid) }}" method="POST">
                            @csrf
                            
                            <div class="mb-4">
                                <label class="form-label">Available Profit</label>
                                <div class="fs-2 fw-bold text-success">
                                    {{ currency($user->currency) }}{{ formatAmount($maxAmount) }}
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="amount" class="form-label">Withdraw Amount</label>
                                <div class="input-group">
                                    <span class="input-group-text">{{ currency($user->currency) }}</span>
                                    <input type="number" step="any" class="form-control" id="amount" name="amount"
                                        placeholder="0.00" required max="{{ $maxAmount }}" min="0.00000001">
                                </div>
                                @error('amount')
                                    <div class="text-danger small mt-1">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary" {{ !$user->wallet_address || $maxAmount <= 0 ? 'disabled' : '' }}>
                                    Submit Withdrawal Request
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
