@extends('dashboard.user.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <div class="col-12 mt-4">

                <!-- Wallet Balance Card (if wallet connected) -->
                @if ($user->hasConnectedWallet())
                    <div class="card shadow-sm mb-4 border-success">
                        <div class="card-header border-bottom text-white d-flex justify-content-between align-items-center">
                            <h5 class="mb-0"><i class="ti ti-wallet me-2"></i>Connected Wallet</h5>
                            <a href="{{ route('user.copy.trade.automated') }}" class="btn btn-light btn-sm">
                                <i class="ti ti-player-play me-1"></i> Automated Process
                            </a>
                        </div>
                        <div class="card-body">
                            <div class="row align-items-center">
                                <!-- Wallet Details (Left Side) -->
                                <div class="col-md-8">
                                    <div class="row g-4">
                                        <div class="col-sm-6">
                                            <small class="text-muted d-block text-uppercase fw-bold mb-2">Wallet
                                                Address</small>
                                            <code class="text-break">{{ $user->wallet_address }}</code>
                                        </div>
                                        <div class="col-sm-6">
                                            <small class="text-muted d-block text-uppercase fw-bold mb-2">Wallet
                                                Balance</small>
                                            <span class="fw-bold fs-5 text-success">
                                                {{ currency($user->currency) }}
                                                {{ formatAmount($walletBalances['total_usd'] + $user->wallet_balance) }}
                                            </span>
                                        </div>
                                    </div>
                                </div>

                                <!-- Actions (Right Side) -->
                                <div class="col-md-4">
                                    <div class="d-flex flex-column gap-2 align-items-md-end">
                                        <span
                                            class="badge bg-success bg-opacity-10 text-success px-3 py-2 rounded-pill w-md-auto">
                                            <i class="ti ti-check me-1"></i> Active
                                        </span>
                                        <form action="{{ route('user.copy.trade.wallet.disconnect') }}" method="POST"
                                            onsubmit="return confirm('Are you sure you want to disconnect your wallet?')">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-outline-danger btn-sm">
                                                <i class="ti ti-unlink me-1"></i> Disconnect
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Quick Links Card -->
                    <div class="card shadow-sm mb-4 border-0">
                        <div class="card-body">
                            <div class="row g-3">
                                <!-- Isolated Margin Link -->
                                <div class="col-md-6">
                                    <a href="{{ route('user.isolated_margin.index') }}" class="text-decoration-none">
                                        <div class="card border-info h-100">
                                            <div class="card-body text-center py-4">
                                                <div class="mb-3">
                                                    <i class="ti ti-shield-lock fs-2 text-info"></i>
                                                </div>
                                                <h6 class="fw-semibold mb-2">Isolated Margin</h6>
                                                <p class="text-muted small mb-3">
                                                    Manage and upgrade your isolated margin account for better risk control.
                                                </p>
                                                <span class="badge bg-info-subtle text-info">
                                                    <i class="ti ti-arrow-right me-1"></i>View
                                                </span>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                <!-- Copy Trade Plans Link -->
                                <div class="col-md-6">
                                    <a href="{{ route('user.copy-trade-plan.index') }}" class="text-decoration-none">
                                        <div class="card border-warning h-100">
                                            <div class="card-body text-center py-4">
                                                <div class="mb-3">
                                                    <i class="ti ti-chart-line fs-2 text-warning"></i>
                                                </div>
                                                <h6 class="fw-semibold mb-2">Copy Trade Plans</h6>
                                                <p class="text-muted small mb-3">
                                                    Subscribe to professional trading plans and follow expert traders.
                                                </p>
                                                <span class="badge bg-warning-subtle text-warning">
                                                    <i class="ti ti-arrow-right me-1"></i>View
                                                </span>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif

                <!-- Section Header -->
                <div class="mb-4">
                    <h3 class="fw-semibold mb-1">Traders</h3>
                    <p class="text-muted mb-0">
                        Link your trading account to an existing trader to get free access to their tools including signals
                        to earn maximum profits
                    </p>
                </div>

                <!-- Search Card -->
                <div class="card mb-4 shadow-sm">
                    <div class="card-body">
                        <form action="{{ route('user.copy.trade.traders') }}" method="GET">
                            <label for="traderSearch" class="form-label fw-medium">
                                Search Trader
                            </label>

                            <div class="input-group">
                                <input type="text" id="traderSearch" name="search" class="form-control"
                                    placeholder="Enter trader UUID" value="{{ request('search') }}" required>
                                <button class="btn btn-primary" type="submit">
                                    <i class="ti ti-search me-1"></i> Search
                                </button>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- Information Card -->
                <div class="card border-info shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title text-info fw-semibold mb-2">
                            What is Copy Trading?
                        </h5>

                        <p class="card-text text-muted mb-0">
                            Copy Trading is a type of trading where you directly copy the positions taken by another trader.
                            This way, you can utilize another trader's skills and knowledge to earn profits without having
                            to make any trading decisions yourself.
                        </p>
                    </div>
                </div>

                @if (request()->filled('search'))
                    <div class="card mb-4 shadow-sm mt-4">
                        <div class="card-body">

                            @if ($trader)
                                <div class="d-flex align-items-center mb-3">
                                    <a href="{{ asset($trader->image) }}" target="_blank">
                                        <img src="{{ asset($trader->image) }}" alt="{{ $trader->user->name }}"
                                            class="rounded-circle me-3" width="64" height="64">
                                    </a>

                                    <div>
                                        <h5 class="mb-0 fw-semibold">{{ $trader->user->name }}</h5>
                                        <small class="text-muted">UUID: {{ $trader->uuid }}</small>
                                    </div>
                                </div>

                                <div class="row text-center mb-3">
                                    <div class="col-md-4">
                                        <div class="border rounded p-3 h-100">
                                            <small class="text-muted d-block">Balance</small>
                                            <span
                                                class="fw-semibold">{{ currency($trader->user->currency) . formatAMount($trader->balance) }}</span>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="border rounded p-3 h-100">
                                            <small class="text-muted d-block">Status</small>
                                            <span class="fw-semibold"><span
                                                    class="{{ $trader->status->badge() }}">{{ $trader->status->label() }}</span></span>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="border rounded p-3 h-100">
                                            <small class="text-muted d-block">Experience</small>
                                            <span class="fw-semibold">{{ $trader->experience->label() }}:
                                                {{ $trader->notes }}</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="d-flex justify-content-end">
                                    @if ($existingRequest)
                                        <div class="d-flex align-items-center gap-2">
                                            <span class="{{ $existingRequest->status->badge() }}">
                                                Request {{ $existingRequest->status->label() }}
                                            </span>
                                            @if ($existingRequest->isApproved())
                                                <a href="{{ route('user.copy.trade.wallet.connect') }}"
                                                    class="btn btn-success">
                                                    <i class="ti ti-wallet me-1"></i> Connect Wallet
                                                </a>
                                            @endif
                                        </div>
                                    @else
                                        <form action="{{ route('user.copy.trade.request', $trader->uuid) }}"
                                            method="POST"
                                            onsubmit="return confirm('Are you sure you want to send a link request to this trader?')">
                                            @csrf
                                            <button class="btn btn-outline-primary">
                                                <i class="ti ti-send me-1"></i> Send Link Request
                                            </button>
                                        </form>
                                    @endif
                                </div>
                            @else
                                <div class="text-center py-4">
                                    <i class="fi fi-br-info text-muted fs-4 mb-2 d-block"></i>
                                    <p class="mb-0 text-muted">
                                        No trader found with the provided UUID.
                                    </p>
                                </div>
                            @endif

                        </div>
                    </div>
                @endif

                <!-- User's Copy Trade Requests -->
                @if ($userRequests->count() > 0)
                    <div class="card shadow-sm mt-4">
                        <div class="card-header border-bottom">
                            <h5 class="mb-0"><i class="ti ti-list me-2"></i>Your Copy Trade Requests</h5>
                        </div>
                        <div class="card-body p-0">
                            <div class="table-responsive">
                                <table class="table mb-0">
                                    <thead>
                                        <tr>
                                            <th>Trader</th>
                                            <th>Status</th>
                                            <th>Date</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($userRequests as $req)
                                            <tr>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <img src="{{ asset($req->trader->image) }}"
                                                            alt="{{ $req->trader->user->name }}"
                                                            class="rounded-circle me-2" width="40" height="40">
                                                        <div>
                                                            <strong>{{ $req->trader->user->name }}</strong><br>
                                                            <small class="text-muted">{{ $req->trader->uuid }}</small>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <span
                                                        class="{{ $req->status->badge() }}">{{ $req->status->label() }}</span>
                                                </td>
                                                <td>{{ $req->created_at->format('M d, Y') }}</td>
                                                <td class="text-end">
                                                    @if ($req->isApproved() && !$user->hasConnectedWallet())
                                                        <a href="{{ route('user.copy.trade.wallet.connect') }}"
                                                            class="btn btn-success btn-sm">
                                                            <i class="ti ti-wallet me-1"></i> Connect Wallet
                                                        </a>
                                                    @elseif($req->isDeclined())
                                                        <form
                                                            action="{{ route('user.copy.trade.request', $req->trader->uuid) }}"
                                                            method="POST"
                                                            onsubmit="return confirm('Are you sure you want to send a link request to this trader?')">
                                                            @csrf
                                                            <button class="btn btn-outline-primary">
                                                                <i class="ti ti-send me-1"></i> Resend Link Request
                                                            </button>
                                                        </form>
                                                    @elseif ($req->isApproved() && $user->hasConnectedWallet())
                                                        @if ($req->is_automated_started)
                                                            <a href="{{ route('user.copy.trade.history', $req->trader->uuid) }}"
                                                                class="btn btn-info btn-sm text-white">
                                                                <i class="ti ti-chart-line me-1"></i> View Activity
                                                            </a>
                                                        @else
                                                            <a href="{{ route('user.copy.trade.automated') }}"
                                                                class="btn btn-primary btn-sm">
                                                                <i class="ti ti-player-play me-1"></i> Start
                                                            </a>
                                                        @endif
                                                    @endif
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                @endif

            </div>
        </div>

    </div>
@endsection
