@extends('dashboard.user.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <!-- Balance Card -->
            <div class="col-12 mt-4 mb-4">
                @if ($user->hasConnectedWallet())
                    <div class="card shadow-sm border-success">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <small class="text-muted d-block text-uppercase fw-bold">Connected Wallet Balance</small>
                                    <h3 class="fw-bold text-success mb-0">
                                        {{ currency($user->currency) }}{{ formatAmount($user->wallet_balance) }}
                                    </h3>
                                    <small class="text-muted font-monospace">{{ Str::limit($user->wallet_address, 20) }}</small>
                                </div>
                                <div class="text-end">
                                    <div class="d-flex flex-column gap-2 align-items-end">
                                        <div class="badge bg-success bg-opacity-10 text-success px-3 py-2 rounded-pill">
                                            <i class="ti ti-check me-1"></i> Active
                                        </div>
                                        <form action="{{ route('user.copy.trade.wallet.disconnect') }}" method="POST" 
                                            onsubmit="return confirm('Are you sure you want to disconnect your wallet? This action cannot be undone.')">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-sm">
                                                <i class="ti ti-unlink me-1"></i> Disconnect
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @else
                    <div class="alert alert-warning d-flex align-items-center mb-0">
                        <i class="ti ti-alert-triangle fs-4 me-3"></i>
                        <div>
                            <strong>Wallet Not Connected</strong>
                            <p class="mb-0">Connect your wallet to start seeing real-time activity and profits.</p>
                        </div>
                        <a href="{{ route('user.copy.trade.wallet.connect') }}" class="btn btn-warning ms-auto">Connect Now</a>
                    </div>
                @endif
            </div>

            <!-- Active Subscriptions -->
            <div class="col-lg-12 mb-4">
                <h5 class="fw-semibold mb-3">Active Traders</h5>
                
                @forelse ($subscriptions as $sub)
                    <div class="card shadow-sm mb-3">
                        <div class="card-body">
                            <div class="row align-items-center">
                                <div class="col-md-6 mb-3 mb-md-0">
                                    <div class="d-flex align-items-center">
                                        <a href="{{ asset($sub->trader->image) }}" target="_blank">
                                            <img src="{{ asset($sub->trader->image) }}"
                                                alt="{{ $sub->trader->user->name }}" class="rounded-circle me-3"
                                                width="60" height="60">
                                        </a>
                                        <div>
                                            <h5 class="mb-1 fw-bold">{{ $sub->trader->user->name }}</h5>
                                            <span class="badge bg-primary">UUID: {{ $sub->trader->uuid }}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 text-md-end">
                                    <div class="d-flex justify-content-md-end gap-3">
                                        <div class="text-center px-3 border-end">
                                            <small class="text-muted d-block">Trader Balance</small>
                                            <span class="fw-semibold">{{ currency($sub->trader->user->currency) }}{{ formatAmount($sub->trader->balance) }}</span>
                                        </div>
                                        <div class="text-center px-3">
                                            <small class="text-muted d-block">Since</small>
                                            <span class="fw-semibold">{{ $sub->updated_at->format('M d, Y') }}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @empty
                    <div class="card">
                        <div class="card-body text-center py-5">
                            <i class="ti ti-users-plus fs-1 text-muted mb-3 d-block"></i>
                            <h5>No Active Subscriptions</h5>
                            <p class="text-muted">You are not copying any traders yet.</p>
                            <a href="{{ route('user.copy.trade.index') }}" class="btn btn-primary">Find a Trader</a>
                        </div>
                    </div>
                @endforelse
            </div>

            <!-- Trade History / Activity -->
            <div class="col-lg-12">
                <h5 class="fw-semibold mb-3">Recent Activity</h5>
                
                <div class="card shadow-sm">
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th class="ps-4">Date</th>
                                        <th>Trade</th>
                                        <th>Trader</th>
                                        <th>Invested</th>
                                        <th>Result</th>
                                        <th class="text-end pe-4">Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($tradeHistory as $history)
                                        <tr>
                                            <td class="ps-4">{{ $history->created_at->format('M d, Y H:i') }}</td>
                                            <td>
                                                <span class="fw-medium">{{ $history->copyTrade->name }}</span>
                                            </td>
                                            <td>
                                                @if($history->copyTrade->trader)
                                                    {{ $history->copyTrade->trader->user->name }}
                                                @else
                                                    <span class="text-muted">System</span>
                                                @endif
                                            </td>
                                            <td>{{ currency($user->currency) }}{{ formatAmount($history->invested_amount) }}</td>
                                            <td>
                                                <span class="{{ $history->profit_loss >= 0 ? 'text-success' : 'text-danger' }} fw-bold">
                                                    {{ $history->profit_loss >= 0 ? '+' : '' }}{{ currency($user->currency) }}{{ formatAmount($history->profit_loss) }}
                                                </span>
                                            </td>
                                            <td class="text-end pe-4">
                                                @if ($history->is_active)
                                                    <span class="badge bg-success bg-opacity-10 text-success">Active</span>
                                                @else
                                                    <span class="badge bg-secondary">Closed</span>
                                                @endif
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="6" class="text-center py-5 text-muted">
                                                No trade activity found yet.
                                            </td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                    @if ($tradeHistory->hasPages())
                        <div class="card-footer bg-white">
                            {{ $tradeHistory->links() }}
                        </div>
                    @endif
                </div>
            </div>

        </div>

    </div>
@endsection
