@extends('dashboard.user.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <!-- Hero Section -->
        <div class="row mt-4">
            <div class="col-12">
                <div class="card shadow-lg border-0 overflow-hidden" style="background: linear-gradient(135deg, #1a1d21 0%, #2d3436 100%);">
                    <div class="card-body text-center">
                        <h3 class="display-5 fw-bold text-white mb-3">
                            Copy Trading – INVEST LIKE TOP TRADERS
                        </h3>
                        <p class="lead text-white-50 mb-4 mx-auto" style="max-width: 600px;">
                            Replicate the investment moves of other traders in real time, automatically.
                            No experience needed - let the experts work for you.
                        </p>
                        <a href="{{ route('user.copy.trade.traders') }}" class="btn btn-primary btn-sm px-2 py-1 mb-3">
                            <i class="ti ti-rocket me-2"></i> Begin Automated Copy Trading
                        </a>

                    </div>
                </div>
            </div>
        </div>

        <!-- Why Copy Top-Performing Traders Section -->
        <div class="row mt-5">
            <div class="col-12">
                <h3 class="fw-bold mb-4 text-center">Why Copy Top-Performing Traders?</h3>
                <p class="text-muted text-center mb-4">
                    Invest like our best-performing traders: simply choose a trader to copy, and when they trade, so do you.
                </p>
            </div>
        </div>

        <div class="row g-4">


            <div class="col-md-6 col-lg-4">
                <div class="card h-100 shadow-sm border-0">
                    <div class="card-body text-center p-4">
                        <div class="rounded-circle bg-success bg-opacity-10 d-inline-flex align-items-center justify-content-center mb-3" style="width: 60px; height: 60px;">
                            <i class="ti ti-refresh text-success fs-3"></i>
                        </div>
                        <h6 class="fw-semibold">Real-Time Replication</h6>
                        <p class="text-muted small mb-0">
                            Copied trades are replicated to your portfolio in real time automatically.
                        </p>
                    </div>
                </div>
            </div>

            <div class="col-md-6 col-lg-4">
                <div class="card h-100 shadow-sm border-0">
                    <div class="card-body text-center p-4">
                        <div class="rounded-circle bg-info bg-opacity-10 d-inline-flex align-items-center justify-content-center mb-3" style="width: 60px; height: 60px;">
                            <i class="ti ti-currency-dollar-off text-info fs-3"></i>
                        </div>
                        <h6 class="fw-semibold">No Additional Charges</h6>
                        <p class="text-muted small mb-0">
                            No additional charges for using the CopyTrader feature. Zero management fees.
                        </p>
                    </div>
                </div>
            </div>

            <div class="col-md-6 col-lg-4">
                <div class="card h-100 shadow-sm border-0">
                    <div class="card-body text-center p-4">
                        <div class="rounded-circle bg-warning bg-opacity-10 d-inline-flex align-items-center justify-content-center mb-3" style="width: 60px; height: 60px;">
                            <i class="ti ti-brain text-warning fs-3"></i>
                        </div>
                        <h6 class="fw-semibold">Expert Knowledge</h6>
                        <p class="text-muted small mb-0">
                            Benefit from their knowledge and experience without years of learning.
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Meet Our Popular Investors Section -->
        {{-- <div class="row mt-5">
            <div class="col-12">
                <h3 class="fw-bold mb-2 text-center">Meet Our Popular Investors</h3>
                <p class="text-muted text-center mb-4">
                    Thousands of investors, each with a unique strategy, risk level and transparent track record, are available for you to copy.
                </p>
            </div>
        </div>

        <div class="row g-4 mb-4">
            <div class="col-md-4">
                <div class="card shadow-sm border-0 h-100">
                    <div class="card-body p-4">
                        <div class="d-flex align-items-center mb-3">
                            <div class="rounded-circle bg-primary text-white d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px; font-weight: bold;">
                                JS
                            </div>
                            <div>
                                <h6 class="mb-0 fw-semibold">JohnSmith_Pro</h6>
                                <small class="text-muted">Verified Trader</small>
                            </div>
                        </div>
                        <div class="d-flex justify-content-between align-items-center">
                            <span class="text-muted small">Return (2Y)</span>
                            <span class="text-success fw-bold fs-5">+85.72%</span>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card shadow-sm border-0 h-100">
                    <div class="card-body p-4">
                        <div class="d-flex align-items-center mb-3">
                            <div class="rounded-circle bg-success text-white d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px; font-weight: bold;">
                                MT
                            </div>
                            <div>
                                <h6 class="mb-0 fw-semibold">MasterTrader</h6>
                                <small class="text-muted">Elite Investor</small>
                            </div>
                        </div>
                        <div class="d-flex justify-content-between align-items-center">
                            <span class="text-muted small">Return (2Y)</span>
                            <span class="text-success fw-bold fs-5">+62.33%</span>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card shadow-sm border-0 h-100">
                    <div class="card-body p-4">
                        <div class="d-flex align-items-center mb-3">
                            <div class="rounded-circle bg-info text-white d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px; font-weight: bold;">
                                CW
                            </div>
                            <div>
                                <h6 class="mb-0 fw-semibold">CryptoWizard</h6>
                                <small class="text-muted">Top Performer</small>
                            </div>
                        </div>
                        <div class="d-flex justify-content-between align-items-center">
                            <span class="text-muted small">Return (2Y)</span>
                            <span class="text-success fw-bold fs-5">+45.18%</span>
                        </div>
                    </div>
                </div>
            </div>
        </div> --}}

        <!-- How It Works Section -->
        <div class="row mt-5">
            <div class="col-12">
                <h3 class="fw-bold mb-4 text-center">How It Works</h3>
            </div>
        </div>

        <div class="row g-4 mb-4">
            <div class="col-md-4">
                <div class="card shadow-sm border-0 h-100 text-center">
                    <div class="card-body p-4">
                        <div class="rounded-circle bg-primary text-white d-inline-flex align-items-center justify-content-center mb-3" style="width: 60px; height: 60px; font-size: 24px; font-weight: bold;">
                            1
                        </div>
                        <h5 class="fw-semibold">Select a trader</h5>
                        <p class="text-muted mb-0">
                            Browse through our list of top-performing traders and find one that matches your investment style.
                        </p>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card shadow-sm border-0 h-100 text-center">
                    <div class="card-body p-4">
                        <div class="rounded-circle bg-primary text-white d-inline-flex align-items-center justify-content-center mb-3" style="width: 60px; height: 60px; font-size: 24px; font-weight: bold;">
                            2
                        </div>
                        <h5 class="fw-semibold">Hit the COPY Button</h5>
                        <p class="text-muted mb-0">
                            Send a link request to the trader. Once approved, you can start copying their trades.
                        </p>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card shadow-sm border-0 h-100 text-center">
                    <div class="card-body p-4">
                        <div class="rounded-circle bg-primary text-white d-inline-flex align-items-center justify-content-center mb-3" style="width: 60px; height: 60px; font-size: 24px; font-weight: bold;">
                            3
                        </div>
                        <h5 class="fw-semibold">Connect Your Wallet</h5>
                        <p class="text-muted mb-0">
                            Connect your cryptocurrency wallet and let the automated system replicate trades for you.
                        </p>
                    </div>
                </div>
            </div>

            <div class="col-12">
                <div class="card shadow-sm border-0 h-100 text-center">
                    <div class="card-body p-4">
                        <div class="rounded-circle bg-primary text-white d-inline-flex align-items-center justify-content-center mb-3" style="width: 60px; height: 60px; font-size: 24px; font-weight: bold;">
                            4
                        </div>
                        <h5 class="fw-semibold">Automatic Conversion</h5>
                        <p class="text-muted mb-0">
                            Note: When you connect your crypto wallet to the platform, the system automatically converts your ETH to WETH. WETH serves as the primary tradable pair on the platform. When the approval prompt appears, please proceed to approve the transaction, the entire process takes place within your wallet, ensuring that your funds remain safe and secure.
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <!-- FAQ Section -->
        <div class="row mt-5">
            <div class="col-12">
                <h3 class="fw-bold mb-4 text-center">Frequently Asked Questions</h3>
            </div>
        </div>

        <div class="row mb-5">
            <div class="col-lg-8 mx-auto">
                <div class="accordion" id="faqAccordion">
                    <div class="accordion-item border-0 mb-3 shadow-sm">
                        <h2 class="accordion-header" id="faq1">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse1">
                                Is there a fee for copying another trader?
                            </button>
                        </h2>
                        <div id="faqCollapse1" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                            <div class="accordion-body text-muted">
                                There is no additional charge for copying another trader or traders. You will still be charged standard spreads on trading and/or transaction fees where applicable.
                            </div>
                        </div>
                    </div>

                    <div class="accordion-item border-0 mb-3 shadow-sm">
                        <h2 class="accordion-header" id="faq2">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse2">
                                What is the minimum amount required to copy a trader?
                            </button>
                        </h2>
                        <div id="faqCollapse2" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                            <div class="accordion-body text-muted">
                                The minimum amount required to copy a trader is $1000.
                            </div>
                        </div>
                    </div>

                    <div class="accordion-item border-0 mb-3 shadow-sm">
                        <h2 class="accordion-header" id="faq3">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse3">
                                How do I start copy trading?
                            </button>
                        </h2>
                        <div id="faqCollapse3" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                            <div class="accordion-body text-muted">
                                Setting up your copy trading is simple. Choose the trader that you'd like to copy, send a link request, and once approved - connect your wallet. You'll be duplicating their positions automatically in real time.
                            </div>
                        </div>
                    </div>

                    <div class="accordion-item border-0 shadow-sm">
                        <h2 class="accordion-header" id="faq5">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse5">
                                How fast are trades executed?
                            </button>
                        </h2>
                        <div id="faqCollapse5" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                            <div class="accordion-body text-muted">
                                Trades are typically executed in less than a second from the instant the trader you copy executes their own trades.
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- CTA Section -->
        <div class="row mt-4 mb-5">
            <div class="col-12 text-center">
                <div class="card shadow border-0 bg-primary">
                    <div class="card-body p-5">
                        <h4 class="fw-bold text-white mb-3">Ready to Start?</h4>
                        <p class="text-white-50 mb-4">Join thousands of trader who are already benefiting from copy trading.</p>
                        <a href="{{ route('user.copy.trade.traders') }}" class="btn btn-light btn-lg px-5">
                            <i class="ti ti-rocket me-2"></i> Begin Copy Trading
                        </a>
                    </div>
                </div>
            </div>
        </div>

    </div>
@endsection
