@extends('dashboard.user.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <!-- Trader Info Card -->
            <div class="col-lg-12 mb-4">
                <div class="card shadow-sm border-primary">
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="d-flex align-items-center">
                                <a href="{{ asset($trader->image) }}" target="_blank">
                                    <img src="{{ asset($trader->image) }}" alt="{{ $trader->user->name }}"
                                        class="rounded-circle me-3" width="70" height="70">
                                </a>
                                <div>
                                    <h4 class="mb-1 fw-bold">{{ $trader->user->name }}</h4>
                                    <div class="d-flex gap-2 align-items-center">
                                        <span class="badge bg-primary">UUID: {{ $trader->uuid }}</span>
                                        <span class="badge bg-success bg-opacity-10 text-success">
                                            <i class="ti ti-check me-1"></i> Automated Trading Active
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="text-end d-none d-md-block">
                                <small class="text-muted d-block text-uppercase">Started On</small>
                                <span class="fw-bold fs-5">{{ $request->updated_at->format('M d, Y') }}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Stats Overview -->
            <div class="col-md-4 mb-4">
                <div class="card shadow-sm h-100">
                    <div class="card-body">
                        <h6 class="mb-2">Total Trades Copied</h6>
                        <h2 class="mb-0 fw-bold">{{ $tradeHistory->total() }}</h2>
                    </div>
                </div>
            </div>
            <div class="col-md-4 mb-4">
                <div class="card shadow-sm h-100">
                    <div class="card-body">
                        <h6 class="mb-2">Net Profit/Loss</h6>
                        @php
                            $totalPL = $tradeHistory->getCollection()->sum('profit_loss');
                        @endphp
                        <h2 class="mb-0 fw-bold">
                            {{ $totalPL >= 0 ? '+' : '' }}{{ currency($user->currency) }}{{ formatAmount($totalPL) }}
                        </h2>
                    </div>
                </div>
            </div>
            <div class="col-md-4 mb-4">
                <div class="card shadow-sm h-100 border-success">
                    <div class="card-body">
                        <h6 class="mb-2">Unrealized Profit</h6>
                        <h2 class="mb-0 fw-bold text-success">
                            {{ currency($user->currency) }}{{ formatAmount($unrealizedProfit) }}
                        </h2>
                        @if ($unrealizedProfit > 0)
                            <form action="{{ route('user.copy.trade.withdraw.store', $trader->uuid) }}" method="POST"
                                class="mt-3">
                                @csrf
                                <button type="submit" class="btn btn-success w-100"
                                    onclick="return confirm('Withdraw {{ currency($user->currency) }}{{ formatAmount($unrealizedProfit) }} to your wallet balance?')">
                                    <i class="ti ti-wallet me-1"></i> Withdraw to Wallet
                                </button>
                            </form>
                        @else
                            <p class="text-muted mt-2 mb-0"><small>No profit available to withdraw</small></p>
                        @endif
                    </div>
                </div>
            </div>
          

            <!-- Detailed History -->
            <div class="col-lg-12">
                <div class="card shadow-sm">
                    <div class="card-header border-bottom d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">Trade Activity Log</h5>
                        <a href="{{ route('user.copy.trade.index') }}" class="btn btn-outline-secondary btn-sm">
                            <i class="ti ti-arrow-left me-1"></i> Back
                        </a>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead>
                                    <tr>
                                        <th class="ps-4">Date</th>
                                        <th>Trade Name</th>
                                        <th>Invested Amount</th>
                                        <th>Profit/Loss</th>
                                        <th>Status</th>
                                        <th class="text-end pe-4">Details</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($tradeHistory as $history)
                                        <tr>
                                            <td class="ps-4">{{ $history->created_at->format('M d, Y H:i A') }}</td>
                                            <td>
                                                <span class="fw-semibold">{{ $history->copyTrade->name }}</span>
                                                <br>
                                                <small
                                                    class="text-muted">{{ Str::limit($history->copyTrade->description, 30) }}</small>
                                            </td>
                                            <td>{{ currency($user->currency) }}{{ formatAmount($history->invested_amount) }}
                                            </td>
                                            <td>
                                                <span
                                                    class="{{ $history->profit_loss >= 0 ? 'text-success' : 'text-danger' }} fw-bold">
                                                    {{ $history->profit_loss >= 0 ? '+' : '' }}{{ currency($user->currency) }}{{ formatAmount($history->profit_loss) }}
                                                </span>
                                            </td>
                                            <td>
                                                @if ($history->is_active)
                                                    <span class="badge bg-success bg-opacity-10 text-success">Open</span>
                                                @else
                                                    <span class="badge bg-secondary">Closed</span>
                                                @endif
                                            </td>
                                            <td class="text-end pe-4">
                                                <button type="button" class="btn btn-sm btn-light" data-bs-toggle="modal"
                                                    data-bs-target="#tradeModal{{ $history->id }}">
                                                    <i class="ti ti-eye"></i>
                                                </button>

                                                <!-- Modal -->
                                                <div class="modal fade" id="tradeModal{{ $history->id }}" tabindex="-1"
                                                    aria-hidden="true">
                                                    <div class="modal-dialog text-start">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h5 class="modal-title">Trade Details</h5>
                                                                <button type="button" class="btn-close"
                                                                    data-bs-dismiss="modal" aria-label="Close"></button>
                                                            </div>
                                                            <div class="modal-body">
                                                                <ul class="list-group list-group-flush">
                                                                    <li
                                                                        class="list-group-item d-flex justify-content-between">
                                                                        <span class="text-muted">Trade ID</span>
                                                                        <span>#{{ substr($history->copyTrade->uuid, 0, 8) }}</span>
                                                                    </li>
                                                                    <li
                                                                        class="list-group-item d-flex justify-content-between">
                                                                        <span class="text-muted">Duration</span>
                                                                        <span>{{ $history->copyTrade->duration_hours ?? 'Unlimited' }}
                                                                            Hours</span>
                                                                    </li>
                                                                    <li
                                                                        class="list-group-item d-flex justify-content-between">
                                                                        <span class="text-muted">Started At</span>
                                                                        <span>{{ $history->copyTrade->started_at->format('M d, Y H:i:s') }}</span>
                                                                    </li>
                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="6" class="text-center py-5 text-muted">
                                                <i class="ti ti-chart-line fs-1 mb-2 d-block opacity-25"></i>
                                                <p>No trading activity recorded for this trader yet.</p>
                                            </td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                    @if ($tradeHistory->hasPages())
                        <div class="card-footer bg-white">
                            {{ $tradeHistory->links() }}
                        </div>
                    @endif
                </div>
            </div>
        </div>

    </div>
@endsection
