@extends('dashboard.user.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <div class="col-lg-8 mx-auto mt-4">

                <div class="card shadow-sm">
                    <div class="card-header border-bottom">
                        <h5 class="mb-0"><i class="ti ti-rocket me-2"></i>Start Automated Copy Trading</h5>
                    </div>
                    <div class="card-body text-center py-5">

                        <div class="mb-4">
                            <i class="ti ti-check-circle fs-1 text-success"></i>
                        </div>

                        <h4 class="fw-semibold mb-3">Your Wallet is Connected!</h4>

                        <div class="shadow rounded p-3 mb-4 mx-auto" style="max-width: 500px;">
                            <small class="text-muted d-block mb-1">Connected Wallet Address</small>
                            <code class="fs-6">{{ $user->wallet_address }}</code>
                        </div>

                        <p class="text-muted mb-4">
                            You're all set to begin automated copy trading. Once you start the automated process,
                            your account will automatically copy trades from your linked trader. You will receive
                            a confirmation email once the process is initiated.
                        </p>

                        <div class="alert alert-info text-start mb-4 mx-auto" style="max-width: 500px;">
                            <h6 class="fw-bold mb-2"><i class="ti ti-info-circle me-1"></i> What Happens Next?</h6>
                            <ul class="mb-0 ps-3">
                                <li>Your account will be linked to the automated trading system</li>
                                <li>Trades will be copied automatically in real-time</li>
                                <li>You can monitor all activities from your dashboard</li>
                                <li>Profits and losses will be reflected in your account</li>
                            </ul>
                        </div>

                        <form action="{{ route('user.copy.trade.automated.start') }}" method="POST"
                            onsubmit="return confirm('Are you sure you want to start the automated copy trading process?')">
                            @csrf
                            <div class="d-grid gap-2" style="max-width: 400px; margin: 0 auto;">
                                <button type="submit" class="btn btn-success btn-lg">
                                    <i class="ti ti-player-play me-1"></i> Proceed to Start Automated Process
                                </button>
                                <a href="{{ route('user.copy.trade.index') }}" class="btn btn-outline-secondary">
                                    <i class="ti ti-arrow-left me-1"></i> Back to Copy Trade
                                </a>
                            </div>
                        </form>

                    </div>
                </div>

            </div>
        </div>

    </div>
@endsection
