@extends('dashboard.user.layouts.app')

@section('content')
    <div class="page-container">

        <!-- Page Header -->
        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <!-- Content -->
        <div class="row">
            <div class="col-12 mb-3">
                <a href="{{ route('user.copy-trade-plan.index') }}" class="btn btn-primary ms-2">
                    <i class="ti ti-plus me-1"></i>Subscribe to New Plan
                </a>
            </div>
            @if ($userCopyTradePlans->isEmpty())
                <div class="col-12">
                    <div class="alert alert-info text-center">
                        <p>You haven't subscribed to any copy trade plans yet.</p>
                        <a href="{{ route('user.copy-trade-plan.index') }}" class="btn btn-primary btn-sm">
                            <i class="ti ti-plus me-1"></i>Browse Plans
                        </a>
                    </div>
                </div>
            @else
                @foreach ($userCopyTradePlans as $subscription)
                    <div class="col-lg-6 mb-4">
                        <div class="card shadow-sm">
                            <div class="card-header border-bottom d-flex justify-content-between align-items-center">
                                <h5 class="mb-0">{{ $subscription->copyTradePlan->name }}</h5>
                                <span class="{{ $subscription->status->badge() }}">
                                    {{ $subscription->status->label() }}
                                </span>
                            </div>
                            <div class="card-body">
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <p class="text-muted mb-1"><small>Daily Profit %</small></p>
                                        <h5 class="fw-bold">{{ $subscription->daily_profit }}%</h5>
                                    </div>
                                    <div class="col-md-6">
                                        <p class="text-muted mb-1"><small>Commission Rate</small></p>
                                        <h5 class="fw-bold">{{ $subscription->commission_percentage }}%</h5>
                                    </div>
                                </div>

                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <p class="text-muted mb-1"><small>Start Date</small></p>
                                        <p>{{ $subscription->starts_at->format('M d, Y') }}</p>
                                    </div>
                                    <div class="col-md-6">
                                        <p class="text-muted mb-1"><small>End Date</small></p>
                                        <p>{{ $subscription->ends_at->format('M d, Y') }}</p>
                                    </div>
                                </div>

                                <!-- Progress Bar for Duration -->

                                <div class="mb-3">
                                    <p class="text-muted mb-1"><small>Plan Progress</small></p>
                                    <div class="progress" style="height: 20px;">
                                        <div class="progress-bar" role="progressbar"
                                            style="width: {{ $subscription->progress_percentage }}%"
                                            aria-valuenow="{{ $subscription->progress_percentage }}" aria-valuemin="0"
                                            aria-valuemax="100">
                                            {{ round($subscription->progress_percentage) }}%
                                        </div>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <p class="text-muted mb-1"><small>Plan Type</small></p>
                                    <span class="badge bg-info">{{ $subscription->copyTradePlan->type->label() }}</span>
                                </div>

                                <!-- Features -->
                                <div class="mb-3">
                                    <p class="text-muted mb-2"><small>Features</small></p>
                                    <ul class="list-unstyled">
                                        @foreach ($subscription->copyTradePlan->features as $feature)
                                            <li><small class="text-muted"><i
                                                        class="ti ti-check text-success me-2"></i>{{ $feature }}</small>
                                            </li>
                                        @endforeach
                                    </ul>
                                </div>

                            </div>
                            <div class="card-footer">
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <div>
                                        <small class="text-muted">Unrealized Profit</small>
                                        <h5 class="fw-bold text-success mb-0">
                                            {{ currency($user->currency) }}{{ formatAmount($subscription->unrealized_profit) }}
                                        </h5>
                                    </div>
                                    @if ($subscription->unrealized_profit > 0)
                                        <form
                                            action="{{ route('user.copy-trade-plan.withdraw', $subscription->uuid) }}"
                                            method="POST">
                                            @csrf
                                            <button type="submit" class="btn btn-success btn-sm"
                                                onclick="return confirm('Withdraw {{ currency($user->currency) }}{{ formatAmount($subscription->unrealized_profit) }} to your wallet balance?')">
                                                <i class="ti ti-wallet me-1"></i>Withdraw Profit
                                            </button>
                                        </form>
                                    @endif
                                </div>
                                @if ($subscription->status->value === 'active')
                                    <form action="{{ route('user.copy-trade-plan.cancel', $subscription->uuid) }}"
                                        method="POST" style="display: inline;">
                                        @csrf
                                        <button type="submit" class="btn btn-danger btn-sm"
                                            onclick="return confirm('Are you sure you want to cancel this subscription? You will receive a refund.')">
                                            <i class="ti ti-x me-1"></i>Cancel Subscription
                                        </button>
                                    </form>
                                @endif
                            </div>
                        </div>
                    </div>
                @endforeach
            @endif
        </div>

    </div>
@endsection
