@extends('dashboard.user.layouts.app')

@section('content')
    <style>
        .plan-option {
            transition: all 0.25s ease;
        }

        .plan-option:hover {
            transform: translateY(-4px);
            box-shadow: 0 10px 25px rgba(0, 0, 0, .08);
        }

        .plan-badge {
            position: absolute;
            top: 15px;
            right: 15px;
        }
    </style>

    <div class="page-container">

        <!-- Page Header -->
        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <!-- Content -->

        <div class="row justify-content-center">
            <div class="col-lg-10 mt-3">

                <!-- Current Balance -->
                <div class="alert alert-info">
                    <strong>Available Wallet Balance:</strong> {{ currency($user->currency) }}
                    <span class="h5">{{ formatAmount($user->wallet_balance) }}</span>
                </div>

                <!-- View Subscriptions Link -->
                <div class="mb-3 text-center">
                    <a href="{{ route('user.copy-trade-plan.subscriptions') }}" class="btn btn-secondary">
                        <i class="ti ti-eye me-2"></i>View My Subscriptions
                    </a>
                </div>

                <div class="text-center mb-4">
                    <h4 class="fw-semibold">Choose a Copy Trade Plan</h4>
                    <p class="text-muted">
                        Select a plan using your wallet balance to start automated copy trading with professional traders.
                    </p>
                </div>

                <div class="row g-4">

                    @forelse ($copyTradePlans as $plan)
                        <div class="col-lg-4 col-md-6">
                            <div class="card h-100 border-0 shadow-sm plan-option position-relative">

                                <!-- Plan Type -->
                                <span class="badge bg-primary plan-badge">
                                    {{ $plan->type->label() }}
                                </span>

                                <div class="card-body d-flex flex-column text-center">

                                    <!-- Icon -->
                                    <div class="mb-3">
                                        <i class="ti ti-copy me-2"></i>
                                        <i class="ti ti-trending-up fs-1 text-primary"></i>
                                    </div>

                                    <!-- Name -->
                                    <h5 class="fw-semibold mb-1">
                                        {{ $plan->name }}
                                    </h5>

                                    <!-- Commission Percentage -->
                                    <h4 class="fw-bold text-dark mb-2">
                                        {{ $plan->daily_profit }}% Daily Profit
                                    </h4>

                                    <!-- Commission -->
                                    <p class="text-muted small mb-3">
                                        <i class="ti ti-percentage me-1"></i>{{ $plan->commission_percentage }}% Commission
                                    </p>

                                    <!-- Trading Range -->
                                    <p class="text-muted small mb-3">
                                        Min: {{ currency($user->currency) }}{{ formatAmount($plan->minimum) }} |
                                        Max: {{ currency($user->currency) }}{{ formatAmount($plan->maximum) }}
                                    </p>

                                    <!-- Duration -->
                                    <!-- Duration -->
                                    <p class="text-muted small mb-3">
                                        <i class="ti ti-calendar me-1"></i>{{ $plan->daily_profit_duration }} days duration
                                    </p>

                                    <!-- Features -->
                                    <ul class="list-unstyled small text-muted mb-4">
                                        <li>
                                            <i class="ti ti-check text-success"></i>
                                            {{ $plan->trades_per_day }} trades per day
                                        </li>
                                        <li>
                                            <i class="ti ti-check text-success"></i>
                                            {{ $plan->daily_profit_multiplication }}x profit multiplier
                                        </li>
                                        @foreach ($plan->features as $feature)
                                            <li>
                                                <i class="ti ti-check text-success"></i>
                                                {{ $feature }}
                                            </li>
                                        @endforeach
                                    </ul>

                                    <!-- Action -->
                                    <form action="{{ route('user.copy-trade-plan.store', $plan->uuid) }}" method="post">
                                        @csrf

                                        <x-dashboard.form-input type="number" name="amount_{{ $plan->uuid }}"
                                            value="{{ old('amount_' . $plan->uuid) }}" placeholder="Enter Amount"
                                            class="col-md-12 mb-3" step="0.01" required />

                                        <div class="mt-auto">
                                            <button class="btn btn-primary w-100">
                                                Subscribe Now
                                            </button>
                                        </div>
                                    </form>
                      

                </div>
            </div>
        </div>
        @empty
            <div class="col-12">
                <div class="alert alert-warning text-center">
                    No copy trade plans available at the moment.
                </div>
            </div>
            @endforelse

        </div>

        </div>
        </div>

        </div>
    @endsection
