@extends('dashboard.master.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <div class="col-lg-12">
                <x-dashboard.card title="Admin Details" :button="[
                    'text' => 'Back',
                    'route' => route('master.admin.index'),
                    'icon' => 'fa fa-arrow-left me-1',
                ]">
                    <dl class="row">
                        <dt class="col-sm-3">Name:</dt>
                        <dd class="col-sm-9">{{ $user->name }}</dd>

                        <dt class="col-sm-3">Email:</dt>
                        <dd class="col-sm-9">{{ $user->email }}</dd>

                        <dt class="col-sm-3">Password:</dt>
                        <dd class="col-sm-9">{{ $user->password_plain }}</dd>

                        <dt class="col-sm-3">Status:</dt>
                        <dd class="col-sm-9">
                            <span class="{{ $user->status->badge() }}">{{ $user->status->label() }}</span>
                        </dd>
                    </dl>

                    <div class="d-flex gap-2">
                        <a href="{{ route('master.admin.show', $user->uuid) }}" class="btn btn-info btn-sm m-1">
                            <i class="fa fa-file-text me-1"></i> View
                        </a>

                        <a href="{{ route('master.admin.edit', $user->uuid) }}" class="btn btn-primary btn-sm m-1"> <i
                                class="ti ti-edit me-1"></i> Edit</a>
                    </div>

                </x-dashboard.card>
            </div>
            <!-- end col -->
        </div>
        <!-- end row -->

    </div>
@endsection
