@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            @include('dashboard.admin.user.partials.account_options_and_status')

            <x-dashboard.card title="{{ $title }}" :button="[
                'text' => 'Back to Transactions',
                'route' => route('admin.user.transaction.index', $user->uuid),
                'icon' => 'fa fa-arrow-left me-1',
            ]">

                <x-dashboard.transaction-details :transaction="$transaction" :user="$user" />

            </x-dashboard.card>

        </div>

    </div>
@endsection
