@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            @include('dashboard.admin.user.partials.account_options_and_status')

            <div class="col-lg-12">
                <x-dashboard.card title="{{ $title }}" :button="[
                    'route' => route('admin.user.trade.index', $user->uuid),
                    'text' => 'Back to Trades',
                    'icon' => 'fa fa-arrow-left me-1',
                ]">

                    <dl class="row">
                        <dt class="col-sm-3">Market Asset</dt>
                        <dd class="col-sm-9">{{ $trade->market->asset }}</dd>

                        <dt class="col-sm-3">Type</dt>
                        <dd class="col-sm-9">{{ $trade->type->label() }}</dd>

                        <dt class="col-sm-3">Mode</dt>
                        <dd class="col-sm-9">{{ $trade->mode->label() }}</dd>

                        <dt class="col-sm-3">Amount</dt>
                        <dd class="col-sm-9">{{ formatAmount($trade->amount) }}</dd>

                        <dt class="col-sm-3">Entry Price</dt>
                        <dd class="col-sm-9">{{ formatAmount($trade->entry_price) }}</dd>

                        <dt class="col-sm-3">Exit Price</dt>
                        <dd class="col-sm-9">{{ formatAmount($trade->exit_price) }}</dd>

                        <dt class="col-sm-3">Profit</dt>
                        <dd class="col-sm-9">{{ formatAmount($trade->profit) }}</dd>

                        <dt class="col-sm-3">Status</dt>
                        <dd class="col-sm-9"><span
                                class="{{ $trade->status->badge() }}">{{ $trade->status->label() }}</span></dd>

                        @if ($trade->opened_at)
                            <dt class="col-sm-3">Opened At</dt>
                            <dd class="col-sm-9">
                                {{ $trade->opened_at->diffForHumans() }}
                            </dd>
                        @endif

                        @if ($trade->closed_at)
                            <dt class="col-sm-3">Closed At</dt>
                            <dd class="col-sm-9">
                                {{ $trade->closed_at->diffForHumans() }}
                            </dd>
                        @endif
                    </dl>

                </x-dashboard.card>
            </div>
        </div>
        <!-- end col -->
    </div>
    <!-- end row -->

    </div>
@endsection
