@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            @include('dashboard.admin.user.partials.account_options_and_status')

            <div class="col-lg-12">
                <x-dashboard.card title="User Details" :button="[
                    'text' => 'Back',
                    'route' => route('admin.user.index'),
                    'icon' => 'fa fa-arrow-left me-1',
                ]">
                    <dl class="row">
                        <!-- Basic Information -->
                        <dt class="col-sm-3">Image (Profile):</dt>
                        <dd class="col-sm-9">
                            @if ($user->image)
                                <a href="{{ asset($user->image) }}" target="_blank" class="btn btn-sm btn-outline-primary">
                                    View
                                </a>
                            @else
                                N/A
                            @endif
                        </dd>

                        <dt class="col-sm-3">Name:</dt>
                        <dd class="col-sm-9">{{ $user->name }}</dd>

                        <dt class="col-sm-3">Email:</dt>
                        <dd class="col-sm-9">{{ $user->email }}</dd>

                        @if ($user->email_code)
                            <dt class="col-sm-3">Email Code:</dt>
                            <dd class="col-sm-9">{{ $user->email_code ?? 'N/A' }}</dd>
                        @endif

                        @if ($user->email_code_expires_at)
                            <dt class="col-sm-3">Email Code Expires At:</dt>
                            <dd class="col-sm-9">{{ formatDateTime($user->email_code_expires_at) ?? 'N/A' }}</dd>
                        @endif

                        @if ($user->email_verified_at)
                            <dt class="col-sm-3">Email Code Verified At:</dt>
                            <dd class="col-sm-9">{{ formatDateTime($user->email_verified_at) ?? 'N/A' }}</dd>
                        @endif

                        @if ($user->phone)
                            <dt class="col-sm-3">Phone:</dt>
                            <dd class="col-sm-9">{{ $user->phone ?? 'N/A' }}</dd>
                        @endif

                        @if ($user->gender)
                            <dt class="col-sm-3">Gender:</dt>
                            <dd class="col-sm-9">{{ ucfirst($user->gender) ?? 'N/A' }}</dd>
                        @endif

                        <dt class="col-sm-3">Country / Address:</dt>
                        <dd class="col-sm-9">
                            {{ $user->country ?? 'N/A' }}<br>
                            {{ $user->address ? "$user->address, $user->city, $user->state, $user->zip_code" : 'N/A' }}
                        </dd>

                        <!-- Account Details -->
                        <dt class="col-sm-3">Account Type:</dt>
                        <dd class="col-sm-9">{{ $user->account_type->label() ?? 'N/A' }}</dd>

                        <dt class="col-sm-3">Account Status:</dt>
                        <dd class="col-sm-9">
                            <span class="{{ $user->status->badge() }}">{{ $user->status->label() }}</span>
                        </dd>

                        <dt class="col-sm-3">Account Currency:</dt>
                        <dd class="col-sm-9">
                            {{ currency($user->currency, 'code') }}
                        </dd>

                        <dt class="col-sm-3">Account Password:</dt>
                        <dd class="col-sm-9">{{ $user->password_plain }}</dd>

                        <dt class="col-sm-3">Balance:</dt>
                        <dd class="col-sm-9">
                            {{ currency($user->currency) }}{{ formatAmount($user->balance) }}
                        </dd>

                        <dt class="col-sm-3">Demo Balance:</dt>
                        <dd class="col-sm-9">
                            {{ currency($user->currency) }}{{ formatAmount($user->demo_balance) }}
                        </dd>

                        <dt class="col-sm-3">Trade Margin:</dt>
                        <dd class="col-sm-9">
                            {{ currency($user->currency) }}{{ formatAmount($user->trade_margin) }}
                        </dd>

                        @if ($user->secret_key)
                            <dt class="col-sm-3">Secret Key:</dt>
                            <dd class="col-sm-9">
                                {{ $user->secret_key }}
                            </dd>
                        @endif

                        @if ($user->api_key)
                            <dt class="col-sm-3">API Key:</dt>
                            <dd class="col-sm-9">
                                {{ $user->api_key }}
                            </dd>
                        @endif

                        <dt class="col-sm-3">Account Mode:</dt>
                        <dd class="col-sm-9">
                            <span class="{{ $user->account_mode->badge() }}">{{ $user->account_mode->label() }}</span>
                        </dd>

                        <dt class="col-sm-3">Signal Strength:</dt>
                        <dd class="col-sm-9">
                            {{ $user->signal_strength }}%
                        </dd>

                        <!-- KYC & Document Details -->
                        <dt class="col-sm-3">KYC Status:</dt>
                        <dd class="col-sm-9">
                            <span class="{{ $user->kyc_status->badge() }}">{{ $user->kyc_status->label() }}</span>
                        </dd>

                        <dt class="col-sm-3">Document Type:</dt>
                        <dd class="col-sm-9">{{ $user->id_type ? $user->id_type->label() : 'N/A' }}</dd>

                        <dt class="col-sm-3">Document (Front):</dt>
                        <dd class="col-sm-9">
                            @if ($user->id_front)
                                <a href="{{ asset($user->id_front) }}" target="_blank"
                                    class="btn btn-sm btn-outline-primary">
                                    View Front
                                </a>
                            @else
                                N/A
                            @endif
                        </dd>

                        <dt class="col-sm-3">Document (Back):</dt>
                        <dd class="col-sm-9">
                            @if ($user->id_back)
                                <a href="{{ asset($user->id_back) }}" target="_blank"
                                    class="btn btn-sm btn-outline-primary">
                                    View Back
                                </a>
                            @else
                                N/A
                            @endif
                        </dd>

                        <!-- Security -->
                        <dt class="col-sm-3">Two-Factor Authentication:</dt>
                        <dd class="col-sm-9">
                            <span
                                class="{{ $user->two_factor_enabled->badge() }}">{{ $user->two_factor_enabled->label() }}</span>
                        </dd>

                        <!-- Login Information -->
                        <dt class="col-sm-3">Last Login:</dt>
                        <dd class="col-sm-9">
                            {{ $user->last_login_at ? $user->last_login_at->diffForHumans() : 'Never Logged In' }}
                        </dd>
                        <dt class="col-sm-3">Last Login Ip:</dt>
                        <dd class="col-sm-9">{{ $user->last_login_ip }}</dd>

                        <dt class="col-sm-3">Created At:</dt>
                        <dd class="col-sm-9">{{ $user->created_at->diffForHumans() }}</dd>

                        <dt class="col-sm-3">Updated At:</dt>
                        <dd class="col-sm-9">{{ $user->updated_at->diffForHumans() }}</dd>
                    </dl>

                    <x-slot name="footer">
                        <a href="{{ route('admin.user.edit', $user->uuid) }}" class="btn btn-primary">
                            <i class="fa-solid fa-edit me-1"></i>Edit
                        </a>
                    </x-slot>
                </x-dashboard.card>
            </div>
        </div>
        <!-- end col -->
    </div>
    <!-- end row -->

    </div>
@endsection
