@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            @include('dashboard.admin.user.partials.account_options_and_status')

            <x-dashboard.card title="{{ $title }}" :button="[
                'text' => 'Back',
                'route' => route('admin.user.plan.index', $user->uuid),
                'icon' => 'fa fa-arrow-left me-1',
            ]">

                <dl class="row">
                    <dt class="col-sm-3">Plan</dt>
                    <dd class="col-sm-9">
                        <a href="{{ route('admin.plan.show', $userPlan->plan->uuid) }}">{{ $userPlan->plan->name }}</a>
                    </dd>
                    <dt class="col-sm-3">Amount</dt>
                    <dd class="col-sm-9">
                        {{ currency($user->currency) . formatAmount($userPlan->amount) }}
                    </dd>
                    <dt class="col-sm-3">Daily Profit</dt>
                    <dd class="col-sm-9">
                        {{ $userPlan->daily_profit }}%
                    </dd>
                    <dt class="col-sm-3">Duration (Days)</dt>
                    <dd class="col-sm-9">
                        {{ $userPlan->duration }}
                    </dd>
                    <dt class="col-sm-3">Trades per Day</dt>
                    <dd class="col-sm-9">
                        {{ $userPlan->trades_per_day }}
                    </dd>
                    <dt class="col-sm-3">Days Processed</dt>
                    <dd class="col-sm-9">
                        {{ $userPlan->days_processed }}
                    </dd>
                    @if ($userPlan->starts_at)
                        <dt class="col-sm-3">Starts At</dt>
                        <dd class="col-sm-9">
                            {{ formatDateTime($userPlan->starts_at) }}
                        </dd>
                    @endif
                    @if ($userPlan->ends_at)
                        <dt class="col-sm-3">Ends At</dt>
                        <dd class="col-sm-9">
                            {{ formatDateTime($userPlan->ends_at) }}
                        </dd>
                    @endif
                    <dt class="col-sm-3">Status</dt>
                    <dd class="col-sm-9">
                        <span class="{{ $userPlan->status->badge() }}">{{ $userPlan->status->label() }}</span>
                    </dd>

                </dl>

            </x-dashboard.card>
        </div>
    </div>
@endsection
