@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            @include('dashboard.admin.user.partials.account_options_and_status')

            <div class="col-lg-12">
                <x-dashboard.card title="{{ $title }}" :button="[
                    'route' => route('admin.user.notification.index', $user->uuid),
                    'text' => 'Back',
                    'icon' => 'fa fa-arrow-left me-1',
                ]">

                    <form action="{{ route('admin.user.notification.store', $user->uuid) }}" method="POST">
                        @csrf

                        <div class="row">
                            <x-dashboard.form-input name="title" label="Notification Title" class="col-md-12 mb-3"
                                value="{{ old('title') }}" required />

                            <div class="col-md-12 mb-3">
                                <label for="notification_message" class="form-label">Notification Message</label>
                                <textarea name="message" id="notification_message" class="form-control tinyMCE" rows="12"
                                    placeholder="Enter your message" required>{{ old('message') }}</textarea>

                                <x-dashboard.input-error name="message" />
                            </div>
                        </div>

                        <x-dashboard.form-button />
                    </form>

                </x-dashboard.card>
            </div>
        </div>

    </div>
@endsection
