@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            @include('dashboard.admin.user.partials.account_options_and_status')

            <div class="col-lg-12">
                <x-dashboard.card title="KYC Verification">
                    <dl class="row">
                        <dt class="col-sm-3">ID Type:</dt>
                        <dd class="col-sm-9">{{ $user->id_type ? $user->id_type->label() : 'N/A' }}</dd>

                        <dt class="col-sm-3">ID (Front):</dt>
                        <dd class="col-sm-9">
                            @if ($user->id_front)
                                <a href="{{ asset($user->id_front) }}" target="_blank"
                                    class="btn btn-sm btn-outline-primary">
                                    View Front
                                </a>
                            @else
                                N/A
                            @endif
                        </dd>

                        <dt class="col-sm-3">ID (Back):</dt>
                        <dd class="col-sm-9">
                            @if ($user->id_back)
                                <a href="{{ asset($user->id_back) }}" target="_blank"
                                    class="btn btn-sm btn-outline-primary">
                                    View Back
                                </a>
                            @else
                                N/A
                            @endif
                        </dd>

                        <dt class="col-sm-3">Status:</dt>
                        <dd class="col-sm-9">
                            <span class="{{ $user->kyc_status->badge() }}">
                                {{ $user->kyc_status->label() }}
                            </span>
                        </dd>
                    </dl>

                    @if ($user->kycPendingAndHasDocument())
                        <div class="mb-3">
                            <form action="{{ route('admin.user.kyc', $user->uuid) }}" method="post">
                                @csrf
                                @method('PATCH')

                                <button type="submit" name="status" value="approved" class="btn btn-success">
                                    <i class="fa-solid fa-check-circle me-1"></i>
                                    Approve</button>
                            </form>

                        </div>
                        <div class="mb-3">
                            <form action="{{ route('admin.user.kyc', $user->uuid) }}" method="post">
                                @csrf
                                @method('PATCH')

                                <button type="submit" name="status" value="rejected" class="btn btn-danger"> <i
                                        class="fa-solid fa-times-circle me-1"></i>
                                    Reject</button>
                            </form>
                        </div>
                    @endif
                </x-dashboard.card>
            </div>
        </div>
        <!-- end col -->
    </div>
    <!-- end row -->

    </div>
@endsection
