@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            @include('dashboard.admin.user.partials.account_options_and_status')

            <div class="col-lg-12">
                <form action="{{ route('admin.user.update', $user->uuid) }}" method="post" enctype="multipart/form-data">
                    @csrf
                    @method('PATCH')

                    <x-dashboard.card title="{{ $title }}" :button="[
                        'route' => route('admin.user.show', $user->uuid),
                        'text' => 'Back to profile',
                        'icon' => 'fa fa-arrow-left me-1',
                    ]">
                        <div class="row">
                            <!-- Name -->
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Name</label>
                                <input type="text" name="name" value="{{ old('name', $user->name) }}"
                                    class="form-control @error('name') is-invalid @enderror" placeholder="Enter your name"
                                    required>
                                @error('name')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <!-- Email -->
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Email</label>
                                <input type="email" name="email" value="{{ old('email', $user->email) }}"
                                    class="form-control @error('email') is-invalid @enderror" placeholder="Enter your email"
                                    required>
                                @error('email')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <!-- Phone -->
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Phone Number</label>
                                <input type="text" name="phone" value="{{ old('phone', $user->phone) }}"
                                    class="form-control @error('phone') is-invalid @enderror"
                                    placeholder="Enter your phone number">
                                @error('phone')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <!-- Gender -->
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Gender</label>
                                <select name="gender" class="form-select @error('gender') is-invalid @enderror">
                                    <option value="">Select</option>
                                    <option value="male" @selected($user->gender === 'male')>Male</option>
                                    <option value="female" @selected($user->gender === 'female')>Female</option>
                                    <option value="other" @selected($user->gender === 'other')>Other</option>
                                </select>
                                @error('gender')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <!-- Image -->
                            <div class="col-md-12 mb-3">
                                <label class="form-label">Image (Profile)</label>
                                <input type="file" name="image"
                                    class="form-control @error('image') is-invalid @enderror">
                                @error('image')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <!-- Password -->
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Password</label>
                                <input type="password" autocomplete="new-password" name="password"
                                    class="form-control @error('password') is-invalid @enderror"
                                    placeholder="Enter your password">
                                @error('password')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <!-- Confirm Password -->
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Confirm Password</label>
                                <input type="password" autocomplete="new-password" name="password_confirmation"
                                    class="form-control @error('password_confirmation') is-invalid @enderror"
                                    placeholder="Confirm your password">
                                @error('password_confirmation')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>

                    </x-dashboard.card>

                    <x-dashboard.card>

                        <div class="row">
                            <!-- Account Type -->
                            <div class="col-md-6 mb-3">
                                <label for="account_type" class="form-label fw-semibold">Account Type</label>
                                <select name="account_type" id="account_type"
                                    class="form-select @error('account_type') is-invalid @enderror">
                                    <option value="">Select</option>
                                    @foreach ($accountTypes as $accountType)
                                        <option value="{{ $accountType->value }}"
                                            @if (old('account_type', $user->account_type->value ?? '') == $accountType->value) selected @endif>
                                            {{ $accountType->label() }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('account_type')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Account Mode -->
                            <div class="col-md-6 mb-3">
                                <label for="account_mode" class="form-label fw-semibold">Account Mode</label>
                                <select name="account_mode" id="account_mode"
                                    class="form-select @error('account_mode') is-invalid @enderror">
                                    <option value="">Select</option>
                                    @foreach ($accountModes as $accountMode)
                                        <option value="{{ $accountMode->value }}"
                                            @if (old('account_mode', $user->account_mode->value ?? '') == $accountMode->value) selected @endif>
                                            {{ $accountMode->label() }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('account_mode')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Currencies -->
                            <div class="col-md-6 mb-3">
                                <label for="currency" class="form-label fw-semibold">Currencies</label>
                                <select name="currency" id="currency"
                                    class="form-select @error('currency') is-invalid @enderror">
                                    <option value="">Select</option>
                                    @foreach ($currencies as $currency)
                                        <option value="{{ $currency->value }}"
                                            {{ old('currency', $currency->value) == $user->currency->value ? 'selected' : '' }}>
                                            {{ $currency->name() }}</option>
                                    @endforeach
                                </select>
                                @error('currency')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Two Factor Auth Status -->
                            <div class="col-md-6 mb-3">
                                <label for="two_factor_enabled" class="form-label fw-semibold">Two Factor Auth
                                    Status</label>
                                <select name="two_factor_enabled" id="two_factor_enabled"
                                    class="form-select @error('two_factor_enabled') is-invalid @enderror">
                                    <option value="">Select</option>
                                    @foreach ($twoFactorAuthStatuses as $twoFactorAuthStatus)
                                        <option value="{{ $twoFactorAuthStatus->value }}"
                                            {{ old('two_factor_enabled', $twoFactorAuthStatus->value) == $user->two_factor_enabled->value ? 'selected' : '' }}>
                                            {{ $twoFactorAuthStatus->label() }}</option>
                                    @endforeach
                                </select>
                                @error('two_factor_enabled')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Signal Strength -->
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Signal Strength</label>
                                <input type="text" name="signal_strength"
                                    value="{{ old('signal_strength', $user->signal_strength) }}" type="number"
                                    placeholder="100"
                                    class="form-control @error('signal_strength') is-invalid @enderror">
                                @error('signal_strength')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>

                    </x-dashboard.card>

                    <x-dashboard.card>

                        <!-- Country -->
                        <div class="mb-3">
                            <label for="country" class="form-label fw-semibold">Country</label>
                            <select name="country" id="country"
                                class="form-select @error('country') is-invalid @enderror">
                                <option value="">-- Select Country --</option>
                                @foreach (config('setting.countries') as $country)
                                    <option value="{{ $country }}"
                                        {{ old('country', $user->country) == $country ? 'selected' : '' }}>
                                        {{ $country }}</option>
                                @endforeach
                            </select>
                            @error('country')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Address -->
                        <div class="mb-3">
                            <label for="address" class="form-label fw-semibold">Address</label>
                            <input type="text" name="address" id="address"
                                value="{{ old('address', $user->address) }}"
                                class="form-control @error('address') is-invalid @enderror"
                                placeholder="Enter your address">
                            @error('address')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- City and State -->
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="city" class="form-label fw-semibold">City</label>
                                <input type="text" name="city" id="city"
                                    value="{{ old('city', $user->city) }}"
                                    class="form-control @error('city') is-invalid @enderror"
                                    placeholder="Enter your city">
                                @error('city')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="state" class="form-label fw-semibold">State</label>
                                <input type="text" name="state" id="state"
                                    value="{{ old('state', $user->state) }}"
                                    class="form-control @error('state') is-invalid @enderror"
                                    placeholder="Enter your state">
                                @error('state')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- ZIP Code -->
                        <div class="mb-3">
                            <label for="zip_code" class="form-label fw-semibold">ZIP / Postal Code</label>
                            <input type="text" name="zip_code" id="zip_code"
                                value="{{ old('zip_code', $user->zip_code) }}"
                                class="form-control @error('zip_code') is-invalid @enderror"
                                placeholder="Enter ZIP code">
                            @error('zip_code')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- ID Type -->
                        <div class="mb-3">
                            <label for="id_type" class="form-label fw-semibold">Identification Type</label>
                            <select name="id_type" id="id_type"
                                class="form-select @error('id_type') is-invalid @enderror">
                                <option value="">-- Select ID Type --</option>
                                @foreach ($idTypes as $idType)
                                    <option value="{{ $idType->value }}"
                                        @if (old('id_type', $user->id_type->value ?? '') == $idType->value) selected @endif>
                                        {{ $idType->label() }}
                                    </option>
                                @endforeach
                            </select>
                            @error('id_type')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- ID Uploads -->
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="id_front" class="form-label fw-semibold">Upload Front of ID</label>
                                <input type="file" name="id_front" id="id_front"
                                    class="form-control @error('id_front') is-invalid @enderror">
                                @error('id_front')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6 mb-3">
                                <label for="id_back" class="form-label fw-semibold">Upload Back of ID</label>
                                <input type="file" name="id_back" id="id_back"
                                    class="form-control @error('id_back') is-invalid @enderror">
                                @error('id_back')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <x-slot name="footer">
                            <!-- Submit Button -->
                            <x-dashboard.form-button />
                        </x-slot>

                    </x-dashboard.card>
                </form>

            </div>
        </div>
        <!-- end col -->
    </div>
    <!-- end row -->

    </div>
@endsection
