@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            @include('dashboard.admin.user.partials.account_options_and_status')

            <div class="col-lg-12">

                <x-dashboard.card title="{{ $title }}" :button="[
                    'route' => route('admin.user.deposit.index', $user->uuid),
                    'text' => 'Back',
                    'icon' => 'fa fa-arrow-left me-1',
                ]">

                    <x-dashboard.transaction-details :transaction="$transaction" :user="$user" />

                </x-dashboard.card>

                @if ($transaction->meta)
                    <x-dashboard.card>

                        <dl class="row">
                            <dt class="col-sm-3">Payment Transaction Hash / ID:</dt>
                            <dd class="col-sm-9">{{ $transaction->meta['deposit']['transaction_hash'] }}</dd>

                            <dt class="col-sm-3">Payment Proof:</dt>
                            <dd class="col-sm-9"><img src="{{ asset($transaction->proof) }}" width="200"
                                    class="img-thumbnail" alt="{{ $transaction->reference_id }}"></dd>

                            <dt class="col-sm-3">Payment Method:</dt>
                            <dd class="col-sm-9">{{ $transaction->method->label() }}</dd>

                            <dt class="col-sm-3">Payment Wallet Name:</dt>
                            <dd class="col-sm-9">{{ $transaction->meta['deposit']['wallet_name'] }}</dd>

                            <dt class="col-sm-3">Payment Wallet Symbol:</dt>
                            <dd class="col-sm-9">{{ $transaction->meta['deposit']['wallet_symbol'] }}</dd>

                            <dt class="col-sm-3">Payment Wallet Address:</dt>
                            <dd class="col-sm-9">{{ $transaction->meta['deposit']['wallet_address'] }}</dd>

                            <dt class="col-sm-3">Payment Wallet Network:</dt>
                            <dd class="col-sm-9">{{ $transaction->meta['deposit']['wallet_network'] }}</dd>
                        </dl>

                    </x-dashboard.card>

                    <x-dashboard.card>

                        <form action="{{ route('admin.user.deposit.update', [$user->uuid, $transaction->uuid]) }}"
                            method="POST">
                            @csrf
                            @method('PUT')

                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <div class="form-group">
                                        <label for="example-select" class="form-label">Status:</label>
                                        <select name="status" id="example-select" class="form-select">
                                            @foreach ($transactionStatues as $status)
                                                <option value="{{ $status->value }}" @selected($status->value === $transaction->status->value)>
                                                    {{ $status->label() }}</option>
                                            @endforeach

                                        </select>
                                    </div>
                                </div>

                            </div>

                            <x-dashboard.form-button />

                        </form>

                    </x-dashboard.card>
                @endif

            </div>
        </div>

    </div>
@endsection
