@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <x-dashboard.card title="{{ $title }}" :button="[
                'route' => route('admin.trader.create'),
                'text' => 'Add New Trader',
                'icon' => 'fa fa-plus me-1',
            ]">

                <div class="table-responsive d-none d-md-block">
                    <table id="myTable" class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>User</th>
                                <th>Balance</th>
                                <th>Status</th>
                                <th>Experience</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($traders as $trader)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>
                                        {{ $trader->user->name }}
                                    </td>
                                    <td>
                                        {{ currency($trader->user->currency) . formatAmount($trader->balance) }}
                                    </td>
                                    <td>
                                        <span class="{{ $trader->status->badge() }}"> {{ $trader->status->label() }}</span>
                                    </td>
                                    <td>{{ $trader->experience->label() }}</td>
                                    <td>
                                        <a href="{{ route('admin.trader.show', $trader->uuid) }}"
                                            class="btn btn-info btn-sm m-1">
                                            <i class="fa fa-file-text me-1"></i> View
                                        </a>

                                        <a href="{{ route('admin.trader.edit', $trader->uuid) }}"
                                            class="btn btn-primary btn-sm m-1">
                                            <i class="fa fa-edit me-1"></i> Edit
                                        </a>

                                        <form action="{{ route('admin.trader.delete', $trader->uuid) }}" method="POST"
                                            class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-sm m-1"
                                                onclick="return confirm('Are you sure you want to delete this trader?')">
                                                <i class="fa fa-trash me-1"></i>Delete
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <div class="d-block d-md-none">
                    @foreach ($traders as $trader)
                        <div class="card mb-3 shadow-sm">
                            <div class="card-body">
                                <h5 class="card-title">
                                    <strong> User:</strong>
                                    {{ $trader->user->name }}
                                </h5>

                                <p class="mb-1"><strong>Balance:</strong>
                                    {{ currency($trader->user->currency) . formatAmount($trader->balance) }}
                                </p>
                                <p class="mb-1"><strong>Status:</strong>
                                    <span class="{{ $trader->status->badge() }}"> {{ $trader->status->label() }}</span>
                                </p>
                                <p class="mb-2"><strong>Experience:</strong>
                                    {{ $trader->experience->label() }}
                                </p>
                                <div class="d-flex gap-2">
                                    <a href="{{ route('admin.trader.show', $trader->uuid) }}"
                                        class="btn btn-info btn-sm m-1">
                                        <i class="fa fa-file-text me-1"></i> View
                                    </a>

                                    <a href="{{ route('admin.trader.edit', $trader->uuid) }}"
                                        class="btn btn-primary btn-sm m-1">
                                        <i class="fa fa-edit me-1"></i> Edit
                                    </a>

                                    <form action="{{ route('admin.trader.delete', $trader->uuid) }}" method="POST"
                                        class="d-inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger btn-sm m-1"
                                            onclick="return confirm('Are you sure you want to delete this trader?')">
                                            <i class="fa fa-trash me-1"></i>Delete
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>

            </x-dashboard.card>
        </div>

    </div>
@endsection
